import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface GameliftAliasConfig extends TerraformMetaArguments {
    readonly description?: string;
    readonly name: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** routing_strategy block */
    readonly routingStrategy: GameliftAliasRoutingStrategy[];
}
export interface GameliftAliasRoutingStrategy {
    readonly fleetId?: string;
    readonly message?: string;
    readonly type: string;
}
export declare class GameliftAlias extends TerraformResource {
    constructor(scope: Construct, id: string, config: GameliftAliasConfig);
    get arn(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _routingStrategy;
    get routingStrategy(): GameliftAliasRoutingStrategy[];
    set routingStrategy(value: GameliftAliasRoutingStrategy[]);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
