import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface GameliftBuildConfig extends TerraformMetaArguments {
    readonly name: string;
    readonly operatingSystem: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly version?: string;
    /** storage_location block */
    readonly storageLocation: GameliftBuildStorageLocation[];
}
export interface GameliftBuildStorageLocation {
    readonly bucket: string;
    readonly key: string;
    readonly roleArn: string;
}
export declare class GameliftBuild extends TerraformResource {
    constructor(scope: Construct, id: string, config: GameliftBuildConfig);
    get arn(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _operatingSystem;
    get operatingSystem(): string;
    set operatingSystem(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _version?;
    get version(): string | undefined;
    set version(value: string | undefined);
    private _storageLocation;
    get storageLocation(): GameliftBuildStorageLocation[];
    set storageLocation(value: GameliftBuildStorageLocation[]);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
