import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface GameliftFleetConfig extends TerraformMetaArguments {
    readonly buildId: string;
    readonly description?: string;
    readonly ec2InstanceType: string;
    readonly fleetType?: string;
    readonly instanceRoleArn?: string;
    readonly metricGroups?: string[];
    readonly name: string;
    readonly newGameSessionProtectionPolicy?: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** ec2_inbound_permission block */
    readonly ec2InboundPermission?: GameliftFleetEc2InboundPermission[];
    /** resource_creation_limit_policy block */
    readonly resourceCreationLimitPolicy?: GameliftFleetResourceCreationLimitPolicy[];
    /** runtime_configuration block */
    readonly runtimeConfiguration?: GameliftFleetRuntimeConfiguration[];
    /** timeouts block */
    readonly timeouts?: GameliftFleetTimeouts;
}
export interface GameliftFleetEc2InboundPermission {
    readonly fromPort: number;
    readonly ipRange: string;
    readonly protocol: string;
    readonly toPort: number;
}
export interface GameliftFleetResourceCreationLimitPolicy {
    readonly newGameSessionsPerCreator?: number;
    readonly policyPeriodInMinutes?: number;
}
export interface GameliftFleetRuntimeConfigurationServerProcess {
    readonly concurrentExecutions: number;
    readonly launchPath: string;
    readonly parameters?: string;
}
export interface GameliftFleetRuntimeConfiguration {
    readonly gameSessionActivationTimeoutSeconds?: number;
    readonly maxConcurrentGameSessionActivations?: number;
    /** server_process block */
    readonly serverProcess?: GameliftFleetRuntimeConfigurationServerProcess[];
}
export interface GameliftFleetTimeouts {
    readonly create?: string;
    readonly delete?: string;
}
export declare class GameliftFleet extends TerraformResource {
    constructor(scope: Construct, id: string, config: GameliftFleetConfig);
    get arn(): string;
    private _buildId;
    get buildId(): string;
    set buildId(value: string);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _ec2InstanceType;
    get ec2InstanceType(): string;
    set ec2InstanceType(value: string);
    private _fleetType?;
    get fleetType(): string | undefined;
    set fleetType(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _instanceRoleArn?;
    get instanceRoleArn(): string | undefined;
    set instanceRoleArn(value: string | undefined);
    get logPaths(): string[];
    private _metricGroups?;
    get metricGroups(): string[] | undefined;
    set metricGroups(value: string[] | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _newGameSessionProtectionPolicy?;
    get newGameSessionProtectionPolicy(): string | undefined;
    set newGameSessionProtectionPolicy(value: string | undefined);
    get operatingSystem(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _ec2InboundPermission?;
    get ec2InboundPermission(): GameliftFleetEc2InboundPermission[] | undefined;
    set ec2InboundPermission(value: GameliftFleetEc2InboundPermission[] | undefined);
    private _resourceCreationLimitPolicy?;
    get resourceCreationLimitPolicy(): GameliftFleetResourceCreationLimitPolicy[] | undefined;
    set resourceCreationLimitPolicy(value: GameliftFleetResourceCreationLimitPolicy[] | undefined);
    private _runtimeConfiguration?;
    get runtimeConfiguration(): GameliftFleetRuntimeConfiguration[] | undefined;
    set runtimeConfiguration(value: GameliftFleetRuntimeConfiguration[] | undefined);
    private _timeouts?;
    get timeouts(): GameliftFleetTimeouts | undefined;
    set timeouts(value: GameliftFleetTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
