import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface GameliftGameSessionQueueConfig extends TerraformMetaArguments {
    readonly destinations?: string[];
    readonly name: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly timeoutInSeconds?: number;
    /** player_latency_policy block */
    readonly playerLatencyPolicy?: GameliftGameSessionQueuePlayerLatencyPolicy[];
}
export interface GameliftGameSessionQueuePlayerLatencyPolicy {
    readonly maximumIndividualPlayerLatencyMilliseconds: number;
    readonly policyDurationSeconds?: number;
}
export declare class GameliftGameSessionQueue extends TerraformResource {
    constructor(scope: Construct, id: string, config: GameliftGameSessionQueueConfig);
    get arn(): string;
    private _destinations?;
    get destinations(): string[] | undefined;
    set destinations(value: string[] | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _timeoutInSeconds?;
    get timeoutInSeconds(): number | undefined;
    set timeoutInSeconds(value: number | undefined);
    private _playerLatencyPolicy?;
    get playerLatencyPolicy(): GameliftGameSessionQueuePlayerLatencyPolicy[] | undefined;
    set playerLatencyPolicy(value: GameliftGameSessionQueuePlayerLatencyPolicy[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
