import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface GlacierVaultConfig extends TerraformMetaArguments {
    readonly accessPolicy?: string;
    readonly name: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** notification block */
    readonly notification?: GlacierVaultNotification[];
}
export interface GlacierVaultNotification {
    readonly events: string[];
    readonly snsTopic: string;
}
export declare class GlacierVault extends TerraformResource {
    constructor(scope: Construct, id: string, config: GlacierVaultConfig);
    private _accessPolicy?;
    get accessPolicy(): string | undefined;
    set accessPolicy(value: string | undefined);
    get arn(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get location(): string;
    private _name;
    get name(): string;
    set name(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _notification?;
    get notification(): GlacierVaultNotification[] | undefined;
    set notification(value: GlacierVaultNotification[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
