import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
import { ComplexComputedList } from "cdktf";
export interface GlobalacceleratorAcceleratorConfig extends TerraformMetaArguments {
    readonly enabled?: boolean;
    readonly ipAddressType?: string;
    readonly name: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** attributes block */
    readonly attributes?: GlobalacceleratorAcceleratorAttributes[];
}
export declare class GlobalacceleratorAcceleratorIpSets extends ComplexComputedList {
    get ipAddresses(): string[];
    get ipFamily(): string;
}
export interface GlobalacceleratorAcceleratorAttributes {
    readonly flowLogsEnabled?: boolean;
    readonly flowLogsS3Bucket?: string;
    readonly flowLogsS3Prefix?: string;
}
export declare class GlobalacceleratorAccelerator extends TerraformResource {
    constructor(scope: Construct, id: string, config: GlobalacceleratorAcceleratorConfig);
    get dnsName(): string;
    private _enabled?;
    get enabled(): boolean | undefined;
    set enabled(value: boolean | undefined);
    get hostedZoneId(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _ipAddressType?;
    get ipAddressType(): string | undefined;
    set ipAddressType(value: string | undefined);
    ipSets(index: string): GlobalacceleratorAcceleratorIpSets;
    private _name;
    get name(): string;
    set name(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _attributes?;
    get attributes(): GlobalacceleratorAcceleratorAttributes[] | undefined;
    set attributes(value: GlobalacceleratorAcceleratorAttributes[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
