"use strict";
// https://www.terraform.io/docs/providers/aws/r/globalaccelerator_endpoint_group.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.GlobalacceleratorEndpointGroup = void 0;
const cdktf_1 = require("cdktf");
// Resource
class GlobalacceleratorEndpointGroup extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_globalaccelerator_endpoint_group',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._endpointGroupRegion = config.endpointGroupRegion;
        this._healthCheckIntervalSeconds = config.healthCheckIntervalSeconds;
        this._healthCheckPath = config.healthCheckPath;
        this._healthCheckPort = config.healthCheckPort;
        this._healthCheckProtocol = config.healthCheckProtocol;
        this._listenerArn = config.listenerArn;
        this._thresholdCount = config.thresholdCount;
        this._trafficDialPercentage = config.trafficDialPercentage;
        this._endpointConfiguration = config.endpointConfiguration;
    }
    get endpointGroupRegion() {
        var _a;
        return (_a = this._endpointGroupRegion) !== null && _a !== void 0 ? _a : this.getStringAttribute('endpoint_group_region');
    }
    set endpointGroupRegion(value) {
        this._endpointGroupRegion = value;
    }
    get healthCheckIntervalSeconds() {
        return this._healthCheckIntervalSeconds;
    }
    set healthCheckIntervalSeconds(value) {
        this._healthCheckIntervalSeconds = value;
    }
    get healthCheckPath() {
        return this._healthCheckPath;
    }
    set healthCheckPath(value) {
        this._healthCheckPath = value;
    }
    get healthCheckPort() {
        return this._healthCheckPort;
    }
    set healthCheckPort(value) {
        this._healthCheckPort = value;
    }
    get healthCheckProtocol() {
        return this._healthCheckProtocol;
    }
    set healthCheckProtocol(value) {
        this._healthCheckProtocol = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get listenerArn() {
        return this._listenerArn;
    }
    set listenerArn(value) {
        this._listenerArn = value;
    }
    get thresholdCount() {
        return this._thresholdCount;
    }
    set thresholdCount(value) {
        this._thresholdCount = value;
    }
    get trafficDialPercentage() {
        return this._trafficDialPercentage;
    }
    set trafficDialPercentage(value) {
        this._trafficDialPercentage = value;
    }
    get endpointConfiguration() {
        return this._endpointConfiguration;
    }
    set endpointConfiguration(value) {
        this._endpointConfiguration = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            endpoint_group_region: this._endpointGroupRegion,
            health_check_interval_seconds: this._healthCheckIntervalSeconds,
            health_check_path: this._healthCheckPath,
            health_check_port: this._healthCheckPort,
            health_check_protocol: this._healthCheckProtocol,
            listener_arn: this._listenerArn,
            threshold_count: this._thresholdCount,
            traffic_dial_percentage: this._trafficDialPercentage,
            endpoint_configuration: this._endpointConfiguration,
        };
    }
}
exports.GlobalacceleratorEndpointGroup = GlobalacceleratorEndpointGroup;
//# sourceMappingURL=data:application/json;base64,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