import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface GlueCatalogDatabaseConfig extends TerraformMetaArguments {
    readonly catalogId?: string;
    readonly description?: string;
    readonly locationUri?: string;
    readonly name: string;
    readonly parameters?: {
        [key: string]: string;
    };
}
export declare class GlueCatalogDatabase extends TerraformResource {
    constructor(scope: Construct, id: string, config: GlueCatalogDatabaseConfig);
    get arn(): string;
    private _catalogId?;
    get catalogId(): string | undefined;
    set catalogId(value: string | undefined);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _locationUri?;
    get locationUri(): string | undefined;
    set locationUri(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    } | undefined;
    set parameters(value: {
        [key: string]: string;
    } | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
