import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface GlueCatalogTableConfig extends TerraformMetaArguments {
    readonly catalogId?: string;
    readonly databaseName: string;
    readonly description?: string;
    readonly name: string;
    readonly owner?: string;
    readonly parameters?: {
        [key: string]: string;
    };
    readonly retention?: number;
    readonly tableType?: string;
    readonly viewExpandedText?: string;
    readonly viewOriginalText?: string;
    /** partition_keys block */
    readonly partitionKeys?: GlueCatalogTablePartitionKeys[];
    /** storage_descriptor block */
    readonly storageDescriptor?: GlueCatalogTableStorageDescriptor[];
}
export interface GlueCatalogTablePartitionKeys {
    readonly comment?: string;
    readonly name: string;
    readonly type?: string;
}
export interface GlueCatalogTableStorageDescriptorColumns {
    readonly comment?: string;
    readonly name: string;
    readonly type?: string;
}
export interface GlueCatalogTableStorageDescriptorSerDeInfo {
    readonly name?: string;
    readonly parameters?: {
        [key: string]: string;
    };
    readonly serializationLibrary?: string;
}
export interface GlueCatalogTableStorageDescriptorSkewedInfo {
    readonly skewedColumnNames?: string[];
    readonly skewedColumnValueLocationMaps?: {
        [key: string]: string;
    };
    readonly skewedColumnValues?: string[];
}
export interface GlueCatalogTableStorageDescriptorSortColumns {
    readonly column: string;
    readonly sortOrder: number;
}
export interface GlueCatalogTableStorageDescriptor {
    readonly bucketColumns?: string[];
    readonly compressed?: boolean;
    readonly inputFormat?: string;
    readonly location?: string;
    readonly numberOfBuckets?: number;
    readonly outputFormat?: string;
    readonly parameters?: {
        [key: string]: string;
    };
    readonly storedAsSubDirectories?: boolean;
    /** columns block */
    readonly columns?: GlueCatalogTableStorageDescriptorColumns[];
    /** ser_de_info block */
    readonly serDeInfo?: GlueCatalogTableStorageDescriptorSerDeInfo[];
    /** skewed_info block */
    readonly skewedInfo?: GlueCatalogTableStorageDescriptorSkewedInfo[];
    /** sort_columns block */
    readonly sortColumns?: GlueCatalogTableStorageDescriptorSortColumns[];
}
export declare class GlueCatalogTable extends TerraformResource {
    constructor(scope: Construct, id: string, config: GlueCatalogTableConfig);
    get arn(): string;
    private _catalogId?;
    get catalogId(): string | undefined;
    set catalogId(value: string | undefined);
    private _databaseName;
    get databaseName(): string;
    set databaseName(value: string);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _owner?;
    get owner(): string | undefined;
    set owner(value: string | undefined);
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    } | undefined;
    set parameters(value: {
        [key: string]: string;
    } | undefined);
    private _retention?;
    get retention(): number | undefined;
    set retention(value: number | undefined);
    private _tableType?;
    get tableType(): string | undefined;
    set tableType(value: string | undefined);
    private _viewExpandedText?;
    get viewExpandedText(): string | undefined;
    set viewExpandedText(value: string | undefined);
    private _viewOriginalText?;
    get viewOriginalText(): string | undefined;
    set viewOriginalText(value: string | undefined);
    private _partitionKeys?;
    get partitionKeys(): GlueCatalogTablePartitionKeys[] | undefined;
    set partitionKeys(value: GlueCatalogTablePartitionKeys[] | undefined);
    private _storageDescriptor?;
    get storageDescriptor(): GlueCatalogTableStorageDescriptor[] | undefined;
    set storageDescriptor(value: GlueCatalogTableStorageDescriptor[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
