import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface GlueClassifierConfig extends TerraformMetaArguments {
    readonly name: string;
    /** csv_classifier block */
    readonly csvClassifier?: GlueClassifierCsvClassifier[];
    /** grok_classifier block */
    readonly grokClassifier?: GlueClassifierGrokClassifier[];
    /** json_classifier block */
    readonly jsonClassifier?: GlueClassifierJsonClassifier[];
    /** xml_classifier block */
    readonly xmlClassifier?: GlueClassifierXmlClassifier[];
}
export interface GlueClassifierCsvClassifier {
    readonly allowSingleColumn?: boolean;
    readonly containsHeader?: string;
    readonly delimiter?: string;
    readonly disableValueTrimming?: boolean;
    readonly header?: string[];
    readonly quoteSymbol?: string;
}
export interface GlueClassifierGrokClassifier {
    readonly classification: string;
    readonly customPatterns?: string;
    readonly grokPattern: string;
}
export interface GlueClassifierJsonClassifier {
    readonly jsonPath: string;
}
export interface GlueClassifierXmlClassifier {
    readonly classification: string;
    readonly rowTag: string;
}
export declare class GlueClassifier extends TerraformResource {
    constructor(scope: Construct, id: string, config: GlueClassifierConfig);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _csvClassifier?;
    get csvClassifier(): GlueClassifierCsvClassifier[] | undefined;
    set csvClassifier(value: GlueClassifierCsvClassifier[] | undefined);
    private _grokClassifier?;
    get grokClassifier(): GlueClassifierGrokClassifier[] | undefined;
    set grokClassifier(value: GlueClassifierGrokClassifier[] | undefined);
    private _jsonClassifier?;
    get jsonClassifier(): GlueClassifierJsonClassifier[] | undefined;
    set jsonClassifier(value: GlueClassifierJsonClassifier[] | undefined);
    private _xmlClassifier?;
    get xmlClassifier(): GlueClassifierXmlClassifier[] | undefined;
    set xmlClassifier(value: GlueClassifierXmlClassifier[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
