"use strict";
// https://www.terraform.io/docs/providers/aws/r/glue_classifier.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.GlueClassifier = void 0;
const cdktf_1 = require("cdktf");
// Resource
class GlueClassifier extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_glue_classifier',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._name = config.name;
        this._csvClassifier = config.csvClassifier;
        this._grokClassifier = config.grokClassifier;
        this._jsonClassifier = config.jsonClassifier;
        this._xmlClassifier = config.xmlClassifier;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get name() {
        return this._name;
    }
    set name(value) {
        this._name = value;
    }
    get csvClassifier() {
        return this._csvClassifier;
    }
    set csvClassifier(value) {
        this._csvClassifier = value;
    }
    get grokClassifier() {
        return this._grokClassifier;
    }
    set grokClassifier(value) {
        this._grokClassifier = value;
    }
    get jsonClassifier() {
        return this._jsonClassifier;
    }
    set jsonClassifier(value) {
        this._jsonClassifier = value;
    }
    get xmlClassifier() {
        return this._xmlClassifier;
    }
    set xmlClassifier(value) {
        this._xmlClassifier = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            name: this._name,
            csv_classifier: this._csvClassifier,
            grok_classifier: this._grokClassifier,
            json_classifier: this._jsonClassifier,
            xml_classifier: this._xmlClassifier,
        };
    }
}
exports.GlueClassifier = GlueClassifier;
//# sourceMappingURL=data:application/json;base64,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