import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface GlueConnectionConfig extends TerraformMetaArguments {
    readonly catalogId?: string;
    readonly connectionProperties: {
        [key: string]: string;
    };
    readonly connectionType?: string;
    readonly description?: string;
    readonly matchCriteria?: string[];
    readonly name: string;
    /** physical_connection_requirements block */
    readonly physicalConnectionRequirements?: GlueConnectionPhysicalConnectionRequirements[];
}
export interface GlueConnectionPhysicalConnectionRequirements {
    readonly availabilityZone?: string;
    readonly securityGroupIdList?: string[];
    readonly subnetId?: string;
}
export declare class GlueConnection extends TerraformResource {
    constructor(scope: Construct, id: string, config: GlueConnectionConfig);
    get arn(): string;
    private _catalogId?;
    get catalogId(): string | undefined;
    set catalogId(value: string | undefined);
    private _connectionProperties;
    get connectionProperties(): {
        [key: string]: string;
    };
    set connectionProperties(value: {
        [key: string]: string;
    });
    private _connectionType?;
    get connectionType(): string | undefined;
    set connectionType(value: string | undefined);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _matchCriteria?;
    get matchCriteria(): string[] | undefined;
    set matchCriteria(value: string[] | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _physicalConnectionRequirements?;
    get physicalConnectionRequirements(): GlueConnectionPhysicalConnectionRequirements[] | undefined;
    set physicalConnectionRequirements(value: GlueConnectionPhysicalConnectionRequirements[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
