import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface GlueCrawlerConfig extends TerraformMetaArguments {
    readonly classifiers?: string[];
    readonly configuration?: string;
    readonly databaseName: string;
    readonly description?: string;
    readonly name: string;
    readonly role: string;
    readonly schedule?: string;
    readonly securityConfiguration?: string;
    readonly tablePrefix?: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** catalog_target block */
    readonly catalogTarget?: GlueCrawlerCatalogTarget[];
    /** dynamodb_target block */
    readonly dynamodbTarget?: GlueCrawlerDynamodbTarget[];
    /** jdbc_target block */
    readonly jdbcTarget?: GlueCrawlerJdbcTarget[];
    /** s3_target block */
    readonly s3Target?: GlueCrawlerS3Target[];
    /** schema_change_policy block */
    readonly schemaChangePolicy?: GlueCrawlerSchemaChangePolicy[];
}
export interface GlueCrawlerCatalogTarget {
    readonly databaseName: string;
    readonly tables: string[];
}
export interface GlueCrawlerDynamodbTarget {
    readonly path: string;
}
export interface GlueCrawlerJdbcTarget {
    readonly connectionName: string;
    readonly exclusions?: string[];
    readonly path: string;
}
export interface GlueCrawlerS3Target {
    readonly exclusions?: string[];
    readonly path: string;
}
export interface GlueCrawlerSchemaChangePolicy {
    readonly deleteBehavior?: string;
    readonly updateBehavior?: string;
}
export declare class GlueCrawler extends TerraformResource {
    constructor(scope: Construct, id: string, config: GlueCrawlerConfig);
    get arn(): string;
    private _classifiers?;
    get classifiers(): string[] | undefined;
    set classifiers(value: string[] | undefined);
    private _configuration?;
    get configuration(): string | undefined;
    set configuration(value: string | undefined);
    private _databaseName;
    get databaseName(): string;
    set databaseName(value: string);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _role;
    get role(): string;
    set role(value: string);
    private _schedule?;
    get schedule(): string | undefined;
    set schedule(value: string | undefined);
    private _securityConfiguration?;
    get securityConfiguration(): string | undefined;
    set securityConfiguration(value: string | undefined);
    private _tablePrefix?;
    get tablePrefix(): string | undefined;
    set tablePrefix(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _catalogTarget?;
    get catalogTarget(): GlueCrawlerCatalogTarget[] | undefined;
    set catalogTarget(value: GlueCrawlerCatalogTarget[] | undefined);
    private _dynamodbTarget?;
    get dynamodbTarget(): GlueCrawlerDynamodbTarget[] | undefined;
    set dynamodbTarget(value: GlueCrawlerDynamodbTarget[] | undefined);
    private _jdbcTarget?;
    get jdbcTarget(): GlueCrawlerJdbcTarget[] | undefined;
    set jdbcTarget(value: GlueCrawlerJdbcTarget[] | undefined);
    private _s3Target?;
    get s3Target(): GlueCrawlerS3Target[] | undefined;
    set s3Target(value: GlueCrawlerS3Target[] | undefined);
    private _schemaChangePolicy?;
    get schemaChangePolicy(): GlueCrawlerSchemaChangePolicy[] | undefined;
    set schemaChangePolicy(value: GlueCrawlerSchemaChangePolicy[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
