import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface GlueJobConfig extends TerraformMetaArguments {
    readonly allocatedCapacity?: number;
    readonly connections?: string[];
    readonly defaultArguments?: {
        [key: string]: string;
    };
    readonly description?: string;
    readonly glueVersion?: string;
    readonly maxCapacity?: number;
    readonly maxRetries?: number;
    readonly name: string;
    readonly numberOfWorkers?: number;
    readonly roleArn: string;
    readonly securityConfiguration?: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly timeout?: number;
    readonly workerType?: string;
    /** command block */
    readonly command: GlueJobCommand[];
    /** execution_property block */
    readonly executionProperty?: GlueJobExecutionProperty[];
    /** notification_property block */
    readonly notificationProperty?: GlueJobNotificationProperty[];
}
export interface GlueJobCommand {
    readonly name?: string;
    readonly pythonVersion?: string;
    readonly scriptLocation: string;
}
export interface GlueJobExecutionProperty {
    readonly maxConcurrentRuns?: number;
}
export interface GlueJobNotificationProperty {
    readonly notifyDelayAfter?: number;
}
export declare class GlueJob extends TerraformResource {
    constructor(scope: Construct, id: string, config: GlueJobConfig);
    private _allocatedCapacity?;
    get allocatedCapacity(): number | undefined;
    set allocatedCapacity(value: number | undefined);
    get arn(): string;
    private _connections?;
    get connections(): string[] | undefined;
    set connections(value: string[] | undefined);
    private _defaultArguments?;
    get defaultArguments(): {
        [key: string]: string;
    } | undefined;
    set defaultArguments(value: {
        [key: string]: string;
    } | undefined);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _glueVersion?;
    get glueVersion(): string | undefined;
    set glueVersion(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _maxCapacity?;
    get maxCapacity(): number | undefined;
    set maxCapacity(value: number | undefined);
    private _maxRetries?;
    get maxRetries(): number | undefined;
    set maxRetries(value: number | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _numberOfWorkers?;
    get numberOfWorkers(): number | undefined;
    set numberOfWorkers(value: number | undefined);
    private _roleArn;
    get roleArn(): string;
    set roleArn(value: string);
    private _securityConfiguration?;
    get securityConfiguration(): string | undefined;
    set securityConfiguration(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _timeout?;
    get timeout(): number | undefined;
    set timeout(value: number | undefined);
    private _workerType?;
    get workerType(): string | undefined;
    set workerType(value: string | undefined);
    private _command;
    get command(): GlueJobCommand[];
    set command(value: GlueJobCommand[]);
    private _executionProperty?;
    get executionProperty(): GlueJobExecutionProperty[] | undefined;
    set executionProperty(value: GlueJobExecutionProperty[] | undefined);
    private _notificationProperty?;
    get notificationProperty(): GlueJobNotificationProperty[] | undefined;
    set notificationProperty(value: GlueJobNotificationProperty[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
