import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface GlueSecurityConfigurationConfig extends TerraformMetaArguments {
    readonly name: string;
    /** encryption_configuration block */
    readonly encryptionConfiguration: GlueSecurityConfigurationEncryptionConfiguration[];
}
export interface GlueSecurityConfigurationEncryptionConfigurationCloudwatchEncryption {
    readonly cloudwatchEncryptionMode?: string;
    readonly kmsKeyArn?: string;
}
export interface GlueSecurityConfigurationEncryptionConfigurationJobBookmarksEncryption {
    readonly jobBookmarksEncryptionMode?: string;
    readonly kmsKeyArn?: string;
}
export interface GlueSecurityConfigurationEncryptionConfigurationS3Encryption {
    readonly kmsKeyArn?: string;
    readonly s3EncryptionMode?: string;
}
export interface GlueSecurityConfigurationEncryptionConfiguration {
    /** cloudwatch_encryption block */
    readonly cloudwatchEncryption: GlueSecurityConfigurationEncryptionConfigurationCloudwatchEncryption[];
    /** job_bookmarks_encryption block */
    readonly jobBookmarksEncryption: GlueSecurityConfigurationEncryptionConfigurationJobBookmarksEncryption[];
    /** s3_encryption block */
    readonly s3Encryption: GlueSecurityConfigurationEncryptionConfigurationS3Encryption[];
}
export declare class GlueSecurityConfiguration extends TerraformResource {
    constructor(scope: Construct, id: string, config: GlueSecurityConfigurationConfig);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _encryptionConfiguration;
    get encryptionConfiguration(): GlueSecurityConfigurationEncryptionConfiguration[];
    set encryptionConfiguration(value: GlueSecurityConfigurationEncryptionConfiguration[]);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
