import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface GlueTriggerConfig extends TerraformMetaArguments {
    readonly description?: string;
    readonly enabled?: boolean;
    readonly name: string;
    readonly schedule?: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly type: string;
    readonly workflowName?: string;
    /** actions block */
    readonly actions: GlueTriggerActions[];
    /** predicate block */
    readonly predicate?: GlueTriggerPredicate[];
    /** timeouts block */
    readonly timeouts?: GlueTriggerTimeouts;
}
export interface GlueTriggerActions {
    readonly arguments?: {
        [key: string]: string;
    };
    readonly crawlerName?: string;
    readonly jobName?: string;
    readonly timeout?: number;
}
export interface GlueTriggerPredicateConditions {
    readonly crawlState?: string;
    readonly crawlerName?: string;
    readonly jobName?: string;
    readonly logicalOperator?: string;
    readonly state?: string;
}
export interface GlueTriggerPredicate {
    readonly logical?: string;
    /** conditions block */
    readonly conditions: GlueTriggerPredicateConditions[];
}
export interface GlueTriggerTimeouts {
    readonly create?: string;
    readonly delete?: string;
}
export declare class GlueTrigger extends TerraformResource {
    constructor(scope: Construct, id: string, config: GlueTriggerConfig);
    get arn(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _enabled?;
    get enabled(): boolean | undefined;
    set enabled(value: boolean | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _schedule?;
    get schedule(): string | undefined;
    set schedule(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _type;
    get type(): string;
    set type(value: string);
    private _workflowName?;
    get workflowName(): string | undefined;
    set workflowName(value: string | undefined);
    private _actions;
    get actions(): GlueTriggerActions[];
    set actions(value: GlueTriggerActions[]);
    private _predicate?;
    get predicate(): GlueTriggerPredicate[] | undefined;
    set predicate(value: GlueTriggerPredicate[] | undefined);
    private _timeouts?;
    get timeouts(): GlueTriggerTimeouts | undefined;
    set timeouts(value: GlueTriggerTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
