import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface IamAccessKeyConfig extends TerraformMetaArguments {
    readonly pgpKey?: string;
    readonly status?: string;
    readonly user: string;
}
export declare class IamAccessKey extends TerraformResource {
    constructor(scope: Construct, id: string, config: IamAccessKeyConfig);
    get encryptedSecret(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get keyFingerprint(): string;
    private _pgpKey?;
    get pgpKey(): string | undefined;
    set pgpKey(value: string | undefined);
    get secret(): string;
    get sesSmtpPassword(): string;
    get sesSmtpPasswordV4(): string;
    private _status?;
    get status(): string | undefined;
    set status(value: string | undefined);
    private _user;
    get user(): string;
    set user(value: string);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
