import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface IamAccountPasswordPolicyConfig extends TerraformMetaArguments {
    readonly allowUsersToChangePassword?: boolean;
    readonly hardExpiry?: boolean;
    readonly maxPasswordAge?: number;
    readonly minimumPasswordLength?: number;
    readonly passwordReusePrevention?: number;
    readonly requireLowercaseCharacters?: boolean;
    readonly requireNumbers?: boolean;
    readonly requireSymbols?: boolean;
    readonly requireUppercaseCharacters?: boolean;
}
export declare class IamAccountPasswordPolicy extends TerraformResource {
    constructor(scope: Construct, id: string, config?: IamAccountPasswordPolicyConfig);
    private _allowUsersToChangePassword?;
    get allowUsersToChangePassword(): boolean | undefined;
    set allowUsersToChangePassword(value: boolean | undefined);
    get expirePasswords(): boolean;
    private _hardExpiry?;
    get hardExpiry(): boolean | undefined;
    set hardExpiry(value: boolean | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _maxPasswordAge?;
    get maxPasswordAge(): number | undefined;
    set maxPasswordAge(value: number | undefined);
    private _minimumPasswordLength?;
    get minimumPasswordLength(): number | undefined;
    set minimumPasswordLength(value: number | undefined);
    private _passwordReusePrevention?;
    get passwordReusePrevention(): number | undefined;
    set passwordReusePrevention(value: number | undefined);
    private _requireLowercaseCharacters?;
    get requireLowercaseCharacters(): boolean | undefined;
    set requireLowercaseCharacters(value: boolean | undefined);
    private _requireNumbers?;
    get requireNumbers(): boolean | undefined;
    set requireNumbers(value: boolean | undefined);
    private _requireSymbols?;
    get requireSymbols(): boolean | undefined;
    set requireSymbols(value: boolean | undefined);
    private _requireUppercaseCharacters?;
    get requireUppercaseCharacters(): boolean | undefined;
    set requireUppercaseCharacters(value: boolean | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
