"use strict";
// https://www.terraform.io/docs/providers/aws/r/iam_account_password_policy.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.IamAccountPasswordPolicy = void 0;
const cdktf_1 = require("cdktf");
// Resource
class IamAccountPasswordPolicy extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'aws_iam_account_password_policy',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._allowUsersToChangePassword = config.allowUsersToChangePassword;
        this._hardExpiry = config.hardExpiry;
        this._maxPasswordAge = config.maxPasswordAge;
        this._minimumPasswordLength = config.minimumPasswordLength;
        this._passwordReusePrevention = config.passwordReusePrevention;
        this._requireLowercaseCharacters = config.requireLowercaseCharacters;
        this._requireNumbers = config.requireNumbers;
        this._requireSymbols = config.requireSymbols;
        this._requireUppercaseCharacters = config.requireUppercaseCharacters;
    }
    get allowUsersToChangePassword() {
        return this._allowUsersToChangePassword;
    }
    set allowUsersToChangePassword(value) {
        this._allowUsersToChangePassword = value;
    }
    // expire_passwords - computed: true, optional: false, required: true
    get expirePasswords() {
        return this.getBooleanAttribute('expire_passwords');
    }
    get hardExpiry() {
        var _a;
        return (_a = this._hardExpiry) !== null && _a !== void 0 ? _a : this.getBooleanAttribute('hard_expiry');
    }
    set hardExpiry(value) {
        this._hardExpiry = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get maxPasswordAge() {
        var _a;
        return (_a = this._maxPasswordAge) !== null && _a !== void 0 ? _a : this.getNumberAttribute('max_password_age');
    }
    set maxPasswordAge(value) {
        this._maxPasswordAge = value;
    }
    get minimumPasswordLength() {
        return this._minimumPasswordLength;
    }
    set minimumPasswordLength(value) {
        this._minimumPasswordLength = value;
    }
    get passwordReusePrevention() {
        var _a;
        return (_a = this._passwordReusePrevention) !== null && _a !== void 0 ? _a : this.getNumberAttribute('password_reuse_prevention');
    }
    set passwordReusePrevention(value) {
        this._passwordReusePrevention = value;
    }
    get requireLowercaseCharacters() {
        var _a;
        return (_a = this._requireLowercaseCharacters) !== null && _a !== void 0 ? _a : this.getBooleanAttribute('require_lowercase_characters');
    }
    set requireLowercaseCharacters(value) {
        this._requireLowercaseCharacters = value;
    }
    get requireNumbers() {
        var _a;
        return (_a = this._requireNumbers) !== null && _a !== void 0 ? _a : this.getBooleanAttribute('require_numbers');
    }
    set requireNumbers(value) {
        this._requireNumbers = value;
    }
    get requireSymbols() {
        var _a;
        return (_a = this._requireSymbols) !== null && _a !== void 0 ? _a : this.getBooleanAttribute('require_symbols');
    }
    set requireSymbols(value) {
        this._requireSymbols = value;
    }
    get requireUppercaseCharacters() {
        var _a;
        return (_a = this._requireUppercaseCharacters) !== null && _a !== void 0 ? _a : this.getBooleanAttribute('require_uppercase_characters');
    }
    set requireUppercaseCharacters(value) {
        this._requireUppercaseCharacters = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            allow_users_to_change_password: this._allowUsersToChangePassword,
            hard_expiry: this._hardExpiry,
            max_password_age: this._maxPasswordAge,
            minimum_password_length: this._minimumPasswordLength,
            password_reuse_prevention: this._passwordReusePrevention,
            require_lowercase_characters: this._requireLowercaseCharacters,
            require_numbers: this._requireNumbers,
            require_symbols: this._requireSymbols,
            require_uppercase_characters: this._requireUppercaseCharacters,
        };
    }
}
exports.IamAccountPasswordPolicy = IamAccountPasswordPolicy;
//# sourceMappingURL=data:application/json;base64,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