import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface IamInstanceProfileConfig extends TerraformMetaArguments {
    readonly name?: string;
    readonly namePrefix?: string;
    readonly path?: string;
    readonly role?: string;
    readonly roles?: string[];
}
export declare class IamInstanceProfile extends TerraformResource {
    constructor(scope: Construct, id: string, config?: IamInstanceProfileConfig);
    get arn(): string;
    get createDate(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    private _namePrefix?;
    get namePrefix(): string | undefined;
    set namePrefix(value: string | undefined);
    private _path?;
    get path(): string | undefined;
    set path(value: string | undefined);
    private _role?;
    get role(): string | undefined;
    set role(value: string | undefined);
    private _roles?;
    get roles(): string[] | undefined;
    set roles(value: string[] | undefined);
    get uniqueId(): string;
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
