import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface IamPolicyConfig extends TerraformMetaArguments {
    readonly description?: string;
    readonly name?: string;
    readonly namePrefix?: string;
    readonly path?: string;
    readonly policy: string;
}
export declare class IamPolicy extends TerraformResource {
    constructor(scope: Construct, id: string, config: IamPolicyConfig);
    get arn(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    private _namePrefix?;
    get namePrefix(): string | undefined;
    set namePrefix(value: string | undefined);
    private _path?;
    get path(): string | undefined;
    set path(value: string | undefined);
    private _policy;
    get policy(): string;
    set policy(value: string);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
