import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface IamRoleConfig extends TerraformMetaArguments {
    readonly assumeRolePolicy: string;
    readonly description?: string;
    readonly forceDetachPolicies?: boolean;
    readonly maxSessionDuration?: number;
    readonly name?: string;
    readonly namePrefix?: string;
    readonly path?: string;
    readonly permissionsBoundary?: string;
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class IamRole extends TerraformResource {
    constructor(scope: Construct, id: string, config: IamRoleConfig);
    get arn(): string;
    private _assumeRolePolicy;
    get assumeRolePolicy(): string;
    set assumeRolePolicy(value: string);
    get createDate(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _forceDetachPolicies?;
    get forceDetachPolicies(): boolean | undefined;
    set forceDetachPolicies(value: boolean | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _maxSessionDuration?;
    get maxSessionDuration(): number | undefined;
    set maxSessionDuration(value: number | undefined);
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    private _namePrefix?;
    get namePrefix(): string | undefined;
    set namePrefix(value: string | undefined);
    private _path?;
    get path(): string | undefined;
    set path(value: string | undefined);
    private _permissionsBoundary?;
    get permissionsBoundary(): string | undefined;
    set permissionsBoundary(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get uniqueId(): string;
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
