import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface IamSamlProviderConfig extends TerraformMetaArguments {
    readonly name: string;
    readonly samlMetadataDocument: string;
}
export declare class IamSamlProvider extends TerraformResource {
    constructor(scope: Construct, id: string, config: IamSamlProviderConfig);
    get arn(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _samlMetadataDocument;
    get samlMetadataDocument(): string;
    set samlMetadataDocument(value: string);
    get validUntil(): string;
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
