import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface IamServerCertificateConfig extends TerraformMetaArguments {
    readonly certificateBody: string;
    readonly certificateChain?: string;
    readonly name?: string;
    readonly namePrefix?: string;
    readonly path?: string;
    readonly privateKey: string;
}
export declare class IamServerCertificate extends TerraformResource {
    constructor(scope: Construct, id: string, config: IamServerCertificateConfig);
    private _arn?;
    get arn(): string | undefined;
    set arn(value: string | undefined);
    private _certificateBody;
    get certificateBody(): string;
    set certificateBody(value: string);
    private _certificateChain?;
    get certificateChain(): string | undefined;
    set certificateChain(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    private _namePrefix?;
    get namePrefix(): string | undefined;
    set namePrefix(value: string | undefined);
    private _path?;
    get path(): string | undefined;
    set path(value: string | undefined);
    private _privateKey;
    get privateKey(): string;
    set privateKey(value: string);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
