import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface IamServiceLinkedRoleConfig extends TerraformMetaArguments {
    readonly awsServiceName: string;
    readonly customSuffix?: string;
    readonly description?: string;
}
export declare class IamServiceLinkedRole extends TerraformResource {
    constructor(scope: Construct, id: string, config: IamServiceLinkedRoleConfig);
    get arn(): string;
    private _awsServiceName;
    get awsServiceName(): string;
    set awsServiceName(value: string);
    get createDate(): string;
    private _customSuffix?;
    get customSuffix(): string | undefined;
    set customSuffix(value: string | undefined);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get name(): string;
    get path(): string;
    get uniqueId(): string;
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
