import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface IamUserLoginProfileConfig extends TerraformMetaArguments {
    readonly passwordLength?: number;
    readonly passwordResetRequired?: boolean;
    readonly pgpKey: string;
    readonly user: string;
}
export declare class IamUserLoginProfile extends TerraformResource {
    constructor(scope: Construct, id: string, config: IamUserLoginProfileConfig);
    get encryptedPassword(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get keyFingerprint(): string;
    private _passwordLength?;
    get passwordLength(): number | undefined;
    set passwordLength(value: number | undefined);
    private _passwordResetRequired?;
    get passwordResetRequired(): boolean | undefined;
    set passwordResetRequired(value: boolean | undefined);
    private _pgpKey;
    get pgpKey(): string;
    set pgpKey(value: string);
    private _user;
    get user(): string;
    set user(value: string);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
