import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface IamUserSshKeyConfig extends TerraformMetaArguments {
    readonly encoding: string;
    readonly publicKey: string;
    readonly status?: string;
    readonly username: string;
}
export declare class IamUserSshKey extends TerraformResource {
    constructor(scope: Construct, id: string, config: IamUserSshKeyConfig);
    private _encoding;
    get encoding(): string;
    set encoding(value: string);
    get fingerprint(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _publicKey;
    get publicKey(): string;
    set publicKey(value: string);
    get sshPublicKeyId(): string;
    private _status?;
    get status(): string | undefined;
    set status(value: string | undefined);
    private _username;
    get username(): string;
    set username(value: string);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
