import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface IamUserConfig extends TerraformMetaArguments {
    /** Delete user even if it has non-Terraform-managed IAM access keys, login profile or MFA devices */
    readonly forceDestroy?: boolean;
    readonly name: string;
    readonly path?: string;
    readonly permissionsBoundary?: string;
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class IamUser extends TerraformResource {
    constructor(scope: Construct, id: string, config: IamUserConfig);
    get arn(): string;
    private _forceDestroy?;
    get forceDestroy(): boolean | undefined;
    set forceDestroy(value: boolean | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _path?;
    get path(): string | undefined;
    set path(value: string | undefined);
    private _permissionsBoundary?;
    get permissionsBoundary(): string | undefined;
    set permissionsBoundary(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get uniqueId(): string;
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
