import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface InspectorAssessmentTemplateConfig extends TerraformMetaArguments {
    readonly duration: number;
    readonly name: string;
    readonly rulesPackageArns: string[];
    readonly tags?: {
        [key: string]: string;
    };
    readonly targetArn: string;
}
export declare class InspectorAssessmentTemplate extends TerraformResource {
    constructor(scope: Construct, id: string, config: InspectorAssessmentTemplateConfig);
    get arn(): string;
    private _duration;
    get duration(): number;
    set duration(value: number);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _rulesPackageArns;
    get rulesPackageArns(): string[];
    set rulesPackageArns(value: string[]);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _targetArn;
    get targetArn(): string;
    set targetArn(value: string);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
