import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface InstanceConfig extends TerraformMetaArguments {
    readonly ami: string;
    readonly associatePublicIpAddress?: boolean;
    readonly availabilityZone?: string;
    readonly cpuCoreCount?: number;
    readonly cpuThreadsPerCore?: number;
    readonly disableApiTermination?: boolean;
    readonly ebsOptimized?: boolean;
    readonly fetchPasswordData?: boolean;
    readonly hibernation?: boolean;
    readonly hostId?: string;
    readonly iamInstanceProfile?: string;
    readonly instanceInitiatedShutdownBehavior?: string;
    readonly instanceType: string;
    readonly ipv6AddressCount?: number;
    readonly ipv6Addresses?: string[];
    readonly keyName?: string;
    readonly monitoring?: boolean;
    readonly placementGroup?: string;
    readonly privateIp?: string;
    readonly securityGroups?: string[];
    readonly sourceDestCheck?: boolean;
    readonly subnetId?: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly tenancy?: string;
    readonly userData?: string;
    readonly userDataBase64?: string;
    readonly volumeTags?: {
        [key: string]: string;
    };
    readonly vpcSecurityGroupIds?: string[];
    /** credit_specification block */
    readonly creditSpecification?: InstanceCreditSpecification[];
    /** ebs_block_device block */
    readonly ebsBlockDevice?: InstanceEbsBlockDevice[];
    /** ephemeral_block_device block */
    readonly ephemeralBlockDevice?: InstanceEphemeralBlockDevice[];
    /** metadata_options block */
    readonly metadataOptions?: InstanceMetadataOptions[];
    /** network_interface block */
    readonly networkInterface?: InstanceNetworkInterface[];
    /** root_block_device block */
    readonly rootBlockDevice?: InstanceRootBlockDevice[];
    /** timeouts block */
    readonly timeouts?: InstanceTimeouts;
}
export interface InstanceCreditSpecification {
    readonly cpuCredits?: string;
}
export interface InstanceEbsBlockDevice {
    readonly deleteOnTermination?: boolean;
    readonly deviceName: string;
    readonly encrypted?: boolean;
    readonly iops?: number;
    readonly kmsKeyId?: string;
    readonly snapshotId?: string;
    readonly volumeSize?: number;
    readonly volumeType?: string;
}
export interface InstanceEphemeralBlockDevice {
    readonly deviceName: string;
    readonly noDevice?: boolean;
    readonly virtualName?: string;
}
export interface InstanceMetadataOptions {
    readonly httpEndpoint?: string;
    readonly httpPutResponseHopLimit?: number;
    readonly httpTokens?: string;
}
export interface InstanceNetworkInterface {
    readonly deleteOnTermination?: boolean;
    readonly deviceIndex: number;
    readonly networkInterfaceId: string;
}
export interface InstanceRootBlockDevice {
    readonly deleteOnTermination?: boolean;
    readonly encrypted?: boolean;
    readonly iops?: number;
    readonly kmsKeyId?: string;
    readonly volumeSize?: number;
    readonly volumeType?: string;
}
export interface InstanceTimeouts {
    readonly create?: string;
    readonly delete?: string;
    readonly update?: string;
}
export declare class Instance extends TerraformResource {
    constructor(scope: Construct, id: string, config: InstanceConfig);
    private _ami;
    get ami(): string;
    set ami(value: string);
    get arn(): string;
    private _associatePublicIpAddress?;
    get associatePublicIpAddress(): boolean | undefined;
    set associatePublicIpAddress(value: boolean | undefined);
    private _availabilityZone?;
    get availabilityZone(): string | undefined;
    set availabilityZone(value: string | undefined);
    private _cpuCoreCount?;
    get cpuCoreCount(): number | undefined;
    set cpuCoreCount(value: number | undefined);
    private _cpuThreadsPerCore?;
    get cpuThreadsPerCore(): number | undefined;
    set cpuThreadsPerCore(value: number | undefined);
    private _disableApiTermination?;
    get disableApiTermination(): boolean | undefined;
    set disableApiTermination(value: boolean | undefined);
    private _ebsOptimized?;
    get ebsOptimized(): boolean | undefined;
    set ebsOptimized(value: boolean | undefined);
    private _getPasswordData?;
    get fetchPasswordData(): boolean | undefined;
    set fetchPasswordData(value: boolean | undefined);
    private _hibernation?;
    get hibernation(): boolean | undefined;
    set hibernation(value: boolean | undefined);
    private _hostId?;
    get hostId(): string | undefined;
    set hostId(value: string | undefined);
    private _iamInstanceProfile?;
    get iamInstanceProfile(): string | undefined;
    set iamInstanceProfile(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _instanceInitiatedShutdownBehavior?;
    get instanceInitiatedShutdownBehavior(): string | undefined;
    set instanceInitiatedShutdownBehavior(value: string | undefined);
    get instanceState(): string;
    private _instanceType;
    get instanceType(): string;
    set instanceType(value: string);
    private _ipv6AddressCount?;
    get ipv6AddressCount(): number | undefined;
    set ipv6AddressCount(value: number | undefined);
    private _ipv6Addresses?;
    get ipv6Addresses(): string[] | undefined;
    set ipv6Addresses(value: string[] | undefined);
    private _keyName?;
    get keyName(): string | undefined;
    set keyName(value: string | undefined);
    private _monitoring?;
    get monitoring(): boolean | undefined;
    set monitoring(value: boolean | undefined);
    get networkInterfaceId(): string;
    get outpostArn(): string;
    get passwordData(): string;
    private _placementGroup?;
    get placementGroup(): string | undefined;
    set placementGroup(value: string | undefined);
    get primaryNetworkInterfaceId(): string;
    get privateDns(): string;
    private _privateIp?;
    get privateIp(): string | undefined;
    set privateIp(value: string | undefined);
    get publicDns(): string;
    get publicIp(): string;
    private _securityGroups?;
    get securityGroups(): string[] | undefined;
    set securityGroups(value: string[] | undefined);
    private _sourceDestCheck?;
    get sourceDestCheck(): boolean | undefined;
    set sourceDestCheck(value: boolean | undefined);
    private _subnetId?;
    get subnetId(): string | undefined;
    set subnetId(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _tenancy?;
    get tenancy(): string | undefined;
    set tenancy(value: string | undefined);
    private _userData?;
    get userData(): string | undefined;
    set userData(value: string | undefined);
    private _userDataBase64?;
    get userDataBase64(): string | undefined;
    set userDataBase64(value: string | undefined);
    private _volumeTags?;
    get volumeTags(): {
        [key: string]: string;
    } | undefined;
    set volumeTags(value: {
        [key: string]: string;
    } | undefined);
    private _vpcSecurityGroupIds?;
    get vpcSecurityGroupIds(): string[] | undefined;
    set vpcSecurityGroupIds(value: string[] | undefined);
    private _creditSpecification?;
    get creditSpecification(): InstanceCreditSpecification[] | undefined;
    set creditSpecification(value: InstanceCreditSpecification[] | undefined);
    private _ebsBlockDevice?;
    get ebsBlockDevice(): InstanceEbsBlockDevice[] | undefined;
    set ebsBlockDevice(value: InstanceEbsBlockDevice[] | undefined);
    private _ephemeralBlockDevice?;
    get ephemeralBlockDevice(): InstanceEphemeralBlockDevice[] | undefined;
    set ephemeralBlockDevice(value: InstanceEphemeralBlockDevice[] | undefined);
    private _metadataOptions?;
    get metadataOptions(): InstanceMetadataOptions[] | undefined;
    set metadataOptions(value: InstanceMetadataOptions[] | undefined);
    private _networkInterface?;
    get networkInterface(): InstanceNetworkInterface[] | undefined;
    set networkInterface(value: InstanceNetworkInterface[] | undefined);
    private _rootBlockDevice?;
    get rootBlockDevice(): InstanceRootBlockDevice[] | undefined;
    set rootBlockDevice(value: InstanceRootBlockDevice[] | undefined);
    private _timeouts?;
    get timeouts(): InstanceTimeouts | undefined;
    set timeouts(value: InstanceTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
