"use strict";
// https://www.terraform.io/docs/providers/aws/r/instance.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.Instance = void 0;
const cdktf_1 = require("cdktf");
// Resource
class Instance extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_instance',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._ami = config.ami;
        this._associatePublicIpAddress = config.associatePublicIpAddress;
        this._availabilityZone = config.availabilityZone;
        this._cpuCoreCount = config.cpuCoreCount;
        this._cpuThreadsPerCore = config.cpuThreadsPerCore;
        this._disableApiTermination = config.disableApiTermination;
        this._ebsOptimized = config.ebsOptimized;
        this._getPasswordData = config.fetchPasswordData;
        this._hibernation = config.hibernation;
        this._hostId = config.hostId;
        this._iamInstanceProfile = config.iamInstanceProfile;
        this._instanceInitiatedShutdownBehavior = config.instanceInitiatedShutdownBehavior;
        this._instanceType = config.instanceType;
        this._ipv6AddressCount = config.ipv6AddressCount;
        this._ipv6Addresses = config.ipv6Addresses;
        this._keyName = config.keyName;
        this._monitoring = config.monitoring;
        this._placementGroup = config.placementGroup;
        this._privateIp = config.privateIp;
        this._securityGroups = config.securityGroups;
        this._sourceDestCheck = config.sourceDestCheck;
        this._subnetId = config.subnetId;
        this._tags = config.tags;
        this._tenancy = config.tenancy;
        this._userData = config.userData;
        this._userDataBase64 = config.userDataBase64;
        this._volumeTags = config.volumeTags;
        this._vpcSecurityGroupIds = config.vpcSecurityGroupIds;
        this._creditSpecification = config.creditSpecification;
        this._ebsBlockDevice = config.ebsBlockDevice;
        this._ephemeralBlockDevice = config.ephemeralBlockDevice;
        this._metadataOptions = config.metadataOptions;
        this._networkInterface = config.networkInterface;
        this._rootBlockDevice = config.rootBlockDevice;
        this._timeouts = config.timeouts;
    }
    get ami() {
        return this._ami;
    }
    set ami(value) {
        this._ami = value;
    }
    // arn - computed: true, optional: false, required: true
    get arn() {
        return this.getStringAttribute('arn');
    }
    get associatePublicIpAddress() {
        var _a;
        return (_a = this._associatePublicIpAddress) !== null && _a !== void 0 ? _a : this.getBooleanAttribute('associate_public_ip_address');
    }
    set associatePublicIpAddress(value) {
        this._associatePublicIpAddress = value;
    }
    get availabilityZone() {
        var _a;
        return (_a = this._availabilityZone) !== null && _a !== void 0 ? _a : this.getStringAttribute('availability_zone');
    }
    set availabilityZone(value) {
        this._availabilityZone = value;
    }
    get cpuCoreCount() {
        var _a;
        return (_a = this._cpuCoreCount) !== null && _a !== void 0 ? _a : this.getNumberAttribute('cpu_core_count');
    }
    set cpuCoreCount(value) {
        this._cpuCoreCount = value;
    }
    get cpuThreadsPerCore() {
        var _a;
        return (_a = this._cpuThreadsPerCore) !== null && _a !== void 0 ? _a : this.getNumberAttribute('cpu_threads_per_core');
    }
    set cpuThreadsPerCore(value) {
        this._cpuThreadsPerCore = value;
    }
    get disableApiTermination() {
        return this._disableApiTermination;
    }
    set disableApiTermination(value) {
        this._disableApiTermination = value;
    }
    get ebsOptimized() {
        return this._ebsOptimized;
    }
    set ebsOptimized(value) {
        this._ebsOptimized = value;
    }
    get fetchPasswordData() {
        return this._getPasswordData;
    }
    set fetchPasswordData(value) {
        this._getPasswordData = value;
    }
    get hibernation() {
        return this._hibernation;
    }
    set hibernation(value) {
        this._hibernation = value;
    }
    get hostId() {
        var _a;
        return (_a = this._hostId) !== null && _a !== void 0 ? _a : this.getStringAttribute('host_id');
    }
    set hostId(value) {
        this._hostId = value;
    }
    get iamInstanceProfile() {
        return this._iamInstanceProfile;
    }
    set iamInstanceProfile(value) {
        this._iamInstanceProfile = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get instanceInitiatedShutdownBehavior() {
        return this._instanceInitiatedShutdownBehavior;
    }
    set instanceInitiatedShutdownBehavior(value) {
        this._instanceInitiatedShutdownBehavior = value;
    }
    // instance_state - computed: true, optional: false, required: true
    get instanceState() {
        return this.getStringAttribute('instance_state');
    }
    get instanceType() {
        return this._instanceType;
    }
    set instanceType(value) {
        this._instanceType = value;
    }
    get ipv6AddressCount() {
        var _a;
        return (_a = this._ipv6AddressCount) !== null && _a !== void 0 ? _a : this.getNumberAttribute('ipv6_address_count');
    }
    set ipv6AddressCount(value) {
        this._ipv6AddressCount = value;
    }
    get ipv6Addresses() {
        var _a;
        return (_a = this._ipv6Addresses) !== null && _a !== void 0 ? _a : this.getListAttribute('ipv6_addresses');
    }
    set ipv6Addresses(value) {
        this._ipv6Addresses = value;
    }
    get keyName() {
        var _a;
        return (_a = this._keyName) !== null && _a !== void 0 ? _a : this.getStringAttribute('key_name');
    }
    set keyName(value) {
        this._keyName = value;
    }
    get monitoring() {
        return this._monitoring;
    }
    set monitoring(value) {
        this._monitoring = value;
    }
    // network_interface_id - computed: true, optional: false, required: true
    get networkInterfaceId() {
        return this.getStringAttribute('network_interface_id');
    }
    // outpost_arn - computed: true, optional: false, required: true
    get outpostArn() {
        return this.getStringAttribute('outpost_arn');
    }
    // password_data - computed: true, optional: false, required: true
    get passwordData() {
        return this.getStringAttribute('password_data');
    }
    get placementGroup() {
        var _a;
        return (_a = this._placementGroup) !== null && _a !== void 0 ? _a : this.getStringAttribute('placement_group');
    }
    set placementGroup(value) {
        this._placementGroup = value;
    }
    // primary_network_interface_id - computed: true, optional: false, required: true
    get primaryNetworkInterfaceId() {
        return this.getStringAttribute('primary_network_interface_id');
    }
    // private_dns - computed: true, optional: false, required: true
    get privateDns() {
        return this.getStringAttribute('private_dns');
    }
    get privateIp() {
        var _a;
        return (_a = this._privateIp) !== null && _a !== void 0 ? _a : this.getStringAttribute('private_ip');
    }
    set privateIp(value) {
        this._privateIp = value;
    }
    // public_dns - computed: true, optional: false, required: true
    get publicDns() {
        return this.getStringAttribute('public_dns');
    }
    // public_ip - computed: true, optional: false, required: true
    get publicIp() {
        return this.getStringAttribute('public_ip');
    }
    get securityGroups() {
        var _a;
        return (_a = this._securityGroups) !== null && _a !== void 0 ? _a : this.getListAttribute('security_groups');
    }
    set securityGroups(value) {
        this._securityGroups = value;
    }
    get sourceDestCheck() {
        return this._sourceDestCheck;
    }
    set sourceDestCheck(value) {
        this._sourceDestCheck = value;
    }
    get subnetId() {
        var _a;
        return (_a = this._subnetId) !== null && _a !== void 0 ? _a : this.getStringAttribute('subnet_id');
    }
    set subnetId(value) {
        this._subnetId = value;
    }
    get tags() {
        return this._tags;
    }
    set tags(value) {
        this._tags = value;
    }
    get tenancy() {
        var _a;
        return (_a = this._tenancy) !== null && _a !== void 0 ? _a : this.getStringAttribute('tenancy');
    }
    set tenancy(value) {
        this._tenancy = value;
    }
    get userData() {
        return this._userData;
    }
    set userData(value) {
        this._userData = value;
    }
    get userDataBase64() {
        return this._userDataBase64;
    }
    set userDataBase64(value) {
        this._userDataBase64 = value;
    }
    get volumeTags() {
        return this._volumeTags; // Getting the computed value is not yet implemented
    }
    set volumeTags(value) {
        this._volumeTags = value;
    }
    get vpcSecurityGroupIds() {
        var _a;
        return (_a = this._vpcSecurityGroupIds) !== null && _a !== void 0 ? _a : this.getListAttribute('vpc_security_group_ids');
    }
    set vpcSecurityGroupIds(value) {
        this._vpcSecurityGroupIds = value;
    }
    get creditSpecification() {
        return this._creditSpecification;
    }
    set creditSpecification(value) {
        this._creditSpecification = value;
    }
    get ebsBlockDevice() {
        return this._ebsBlockDevice;
    }
    set ebsBlockDevice(value) {
        this._ebsBlockDevice = value;
    }
    get ephemeralBlockDevice() {
        return this._ephemeralBlockDevice;
    }
    set ephemeralBlockDevice(value) {
        this._ephemeralBlockDevice = value;
    }
    get metadataOptions() {
        return this._metadataOptions;
    }
    set metadataOptions(value) {
        this._metadataOptions = value;
    }
    get networkInterface() {
        return this._networkInterface;
    }
    set networkInterface(value) {
        this._networkInterface = value;
    }
    get rootBlockDevice() {
        return this._rootBlockDevice;
    }
    set rootBlockDevice(value) {
        this._rootBlockDevice = value;
    }
    get timeouts() {
        return this._timeouts;
    }
    set timeouts(value) {
        this._timeouts = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            ami: this._ami,
            associate_public_ip_address: this._associatePublicIpAddress,
            availability_zone: this._availabilityZone,
            cpu_core_count: this._cpuCoreCount,
            cpu_threads_per_core: this._cpuThreadsPerCore,
            disable_api_termination: this._disableApiTermination,
            ebs_optimized: this._ebsOptimized,
            get_password_data: this._getPasswordData,
            hibernation: this._hibernation,
            host_id: this._hostId,
            iam_instance_profile: this._iamInstanceProfile,
            instance_initiated_shutdown_behavior: this._instanceInitiatedShutdownBehavior,
            instance_type: this._instanceType,
            ipv6_address_count: this._ipv6AddressCount,
            ipv6_addresses: this._ipv6Addresses,
            key_name: this._keyName,
            monitoring: this._monitoring,
            placement_group: this._placementGroup,
            private_ip: this._privateIp,
            security_groups: this._securityGroups,
            source_dest_check: this._sourceDestCheck,
            subnet_id: this._subnetId,
            tags: this._tags,
            tenancy: this._tenancy,
            user_data: this._userData,
            user_data_base64: this._userDataBase64,
            volume_tags: this._volumeTags,
            vpc_security_group_ids: this._vpcSecurityGroupIds,
            credit_specification: this._creditSpecification,
            ebs_block_device: this._ebsBlockDevice,
            ephemeral_block_device: this._ephemeralBlockDevice,
            metadata_options: this._metadataOptions,
            network_interface: this._networkInterface,
            root_block_device: this._rootBlockDevice,
            timeouts: this._timeouts,
        };
    }
}
exports.Instance = Instance;
//# sourceMappingURL=data:application/json;base64,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