import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface IotCertificateConfig extends TerraformMetaArguments {
    readonly active: boolean;
    readonly csr?: string;
}
export declare class IotCertificate extends TerraformResource {
    constructor(scope: Construct, id: string, config: IotCertificateConfig);
    private _active;
    get active(): boolean;
    set active(value: boolean);
    get arn(): string;
    get certificatePem(): string;
    private _csr?;
    get csr(): string | undefined;
    set csr(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get privateKey(): string;
    get publicKey(): string;
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
