"use strict";
// https://www.terraform.io/docs/providers/aws/r/iot_thing_principal_attachment.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.IotThingPrincipalAttachment = void 0;
const cdktf_1 = require("cdktf");
// Resource
class IotThingPrincipalAttachment extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_iot_thing_principal_attachment',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._principal = config.principal;
        this._thing = config.thing;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get principal() {
        return this._principal;
    }
    set principal(value) {
        this._principal = value;
    }
    get thing() {
        return this._thing;
    }
    set thing(value) {
        this._thing = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            principal: this._principal,
            thing: this._thing,
        };
    }
}
exports.IotThingPrincipalAttachment = IotThingPrincipalAttachment;
//# sourceMappingURL=data:application/json;base64,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