import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface IotThingTypeConfig extends TerraformMetaArguments {
    readonly deprecated?: boolean;
    readonly name: string;
    /** properties block */
    readonly properties?: IotThingTypeProperties[];
}
export interface IotThingTypeProperties {
    readonly description?: string;
    readonly searchableAttributes?: string[];
}
export declare class IotThingType extends TerraformResource {
    constructor(scope: Construct, id: string, config: IotThingTypeConfig);
    get arn(): string;
    private _deprecated?;
    get deprecated(): boolean | undefined;
    set deprecated(value: boolean | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _properties?;
    get properties(): IotThingTypeProperties[] | undefined;
    set properties(value: IotThingTypeProperties[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
