import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface IotThingConfig extends TerraformMetaArguments {
    readonly attributes?: {
        [key: string]: string;
    };
    readonly name: string;
    readonly thingTypeName?: string;
}
export declare class IotThing extends TerraformResource {
    constructor(scope: Construct, id: string, config: IotThingConfig);
    get arn(): string;
    private _attributes?;
    get attributes(): {
        [key: string]: string;
    } | undefined;
    set attributes(value: {
        [key: string]: string;
    } | undefined);
    get defaultClientId(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _thingTypeName?;
    get thingTypeName(): string | undefined;
    set thingTypeName(value: string | undefined);
    get version(): number;
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
