import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface IotTopicRuleConfig extends TerraformMetaArguments {
    readonly description?: string;
    readonly enabled: boolean;
    readonly name: string;
    readonly sql: string;
    readonly sqlVersion: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** cloudwatch_alarm block */
    readonly cloudwatchAlarm?: IotTopicRuleCloudwatchAlarm[];
    /** cloudwatch_metric block */
    readonly cloudwatchMetric?: IotTopicRuleCloudwatchMetric[];
    /** dynamodb block */
    readonly dynamodb?: IotTopicRuleDynamodb[];
    /** dynamodbv2 block */
    readonly dynamodbv2?: IotTopicRuleDynamodbv2[];
    /** elasticsearch block */
    readonly elasticsearch?: IotTopicRuleElasticsearch[];
    /** error_action block */
    readonly errorAction?: IotTopicRuleErrorAction[];
    /** firehose block */
    readonly firehose?: IotTopicRuleFirehose[];
    /** iot_analytics block */
    readonly iotAnalytics?: IotTopicRuleIotAnalytics[];
    /** iot_events block */
    readonly iotEvents?: IotTopicRuleIotEvents[];
    /** kinesis block */
    readonly kinesis?: IotTopicRuleKinesis[];
    /** lambda block */
    readonly lambda?: IotTopicRuleLambda[];
    /** republish block */
    readonly republish?: IotTopicRuleRepublish[];
    /** s3 block */
    readonly s3?: IotTopicRuleS3[];
    /** sns block */
    readonly sns?: IotTopicRuleSns[];
    /** sqs block */
    readonly sqs?: IotTopicRuleSqs[];
    /** step_functions block */
    readonly stepFunctions?: IotTopicRuleStepFunctions[];
}
export interface IotTopicRuleCloudwatchAlarm {
    readonly alarmName: string;
    readonly roleArn: string;
    readonly stateReason: string;
    readonly stateValue: string;
}
export interface IotTopicRuleCloudwatchMetric {
    readonly metricName: string;
    readonly metricNamespace: string;
    readonly metricTimestamp?: string;
    readonly metricUnit: string;
    readonly metricValue: string;
    readonly roleArn: string;
}
export interface IotTopicRuleDynamodb {
    readonly hashKeyField: string;
    readonly hashKeyType?: string;
    readonly hashKeyValue: string;
    readonly operation?: string;
    readonly payloadField?: string;
    readonly rangeKeyField?: string;
    readonly rangeKeyType?: string;
    readonly rangeKeyValue?: string;
    readonly roleArn: string;
    readonly tableName: string;
}
export interface IotTopicRuleDynamodbv2PutItem {
    readonly tableName: string;
}
export interface IotTopicRuleDynamodbv2 {
    readonly roleArn: string;
    /** put_item block */
    readonly putItem?: IotTopicRuleDynamodbv2PutItem[];
}
export interface IotTopicRuleElasticsearch {
    readonly endpoint: string;
    readonly id: string;
    readonly index: string;
    readonly roleArn: string;
    readonly type: string;
}
export interface IotTopicRuleErrorActionCloudwatchAlarm {
    readonly alarmName: string;
    readonly roleArn: string;
    readonly stateReason: string;
    readonly stateValue: string;
}
export interface IotTopicRuleErrorActionCloudwatchMetric {
    readonly metricName: string;
    readonly metricNamespace: string;
    readonly metricTimestamp?: string;
    readonly metricUnit: string;
    readonly metricValue: string;
    readonly roleArn: string;
}
export interface IotTopicRuleErrorActionDynamodb {
    readonly hashKeyField: string;
    readonly hashKeyType?: string;
    readonly hashKeyValue: string;
    readonly operation?: string;
    readonly payloadField?: string;
    readonly rangeKeyField?: string;
    readonly rangeKeyType?: string;
    readonly rangeKeyValue?: string;
    readonly roleArn: string;
    readonly tableName: string;
}
export interface IotTopicRuleErrorActionDynamodbv2PutItem {
    readonly tableName: string;
}
export interface IotTopicRuleErrorActionDynamodbv2 {
    readonly roleArn: string;
    /** put_item block */
    readonly putItem?: IotTopicRuleErrorActionDynamodbv2PutItem[];
}
export interface IotTopicRuleErrorActionElasticsearch {
    readonly endpoint: string;
    readonly id: string;
    readonly index: string;
    readonly roleArn: string;
    readonly type: string;
}
export interface IotTopicRuleErrorActionFirehose {
    readonly deliveryStreamName: string;
    readonly roleArn: string;
    readonly separator?: string;
}
export interface IotTopicRuleErrorActionIotAnalytics {
    readonly channelName: string;
    readonly roleArn: string;
}
export interface IotTopicRuleErrorActionIotEvents {
    readonly inputName: string;
    readonly messageId?: string;
    readonly roleArn: string;
}
export interface IotTopicRuleErrorActionKinesis {
    readonly partitionKey?: string;
    readonly roleArn: string;
    readonly streamName: string;
}
export interface IotTopicRuleErrorActionLambda {
    readonly functionArn: string;
}
export interface IotTopicRuleErrorActionRepublish {
    readonly qos?: number;
    readonly roleArn: string;
    readonly topic: string;
}
export interface IotTopicRuleErrorActionS3 {
    readonly bucketName: string;
    readonly key: string;
    readonly roleArn: string;
}
export interface IotTopicRuleErrorActionSns {
    readonly messageFormat?: string;
    readonly roleArn: string;
    readonly targetArn: string;
}
export interface IotTopicRuleErrorActionSqs {
    readonly queueUrl: string;
    readonly roleArn: string;
    readonly useBase64: boolean;
}
export interface IotTopicRuleErrorActionStepFunctions {
    readonly executionNamePrefix?: string;
    readonly roleArn: string;
    readonly stateMachineName: string;
}
export interface IotTopicRuleErrorAction {
    /** cloudwatch_alarm block */
    readonly cloudwatchAlarm?: IotTopicRuleErrorActionCloudwatchAlarm[];
    /** cloudwatch_metric block */
    readonly cloudwatchMetric?: IotTopicRuleErrorActionCloudwatchMetric[];
    /** dynamodb block */
    readonly dynamodb?: IotTopicRuleErrorActionDynamodb[];
    /** dynamodbv2 block */
    readonly dynamodbv2?: IotTopicRuleErrorActionDynamodbv2[];
    /** elasticsearch block */
    readonly elasticsearch?: IotTopicRuleErrorActionElasticsearch[];
    /** firehose block */
    readonly firehose?: IotTopicRuleErrorActionFirehose[];
    /** iot_analytics block */
    readonly iotAnalytics?: IotTopicRuleErrorActionIotAnalytics[];
    /** iot_events block */
    readonly iotEvents?: IotTopicRuleErrorActionIotEvents[];
    /** kinesis block */
    readonly kinesis?: IotTopicRuleErrorActionKinesis[];
    /** lambda block */
    readonly lambda?: IotTopicRuleErrorActionLambda[];
    /** republish block */
    readonly republish?: IotTopicRuleErrorActionRepublish[];
    /** s3 block */
    readonly s3?: IotTopicRuleErrorActionS3[];
    /** sns block */
    readonly sns?: IotTopicRuleErrorActionSns[];
    /** sqs block */
    readonly sqs?: IotTopicRuleErrorActionSqs[];
    /** step_functions block */
    readonly stepFunctions?: IotTopicRuleErrorActionStepFunctions[];
}
export interface IotTopicRuleFirehose {
    readonly deliveryStreamName: string;
    readonly roleArn: string;
    readonly separator?: string;
}
export interface IotTopicRuleIotAnalytics {
    readonly channelName: string;
    readonly roleArn: string;
}
export interface IotTopicRuleIotEvents {
    readonly inputName: string;
    readonly messageId?: string;
    readonly roleArn: string;
}
export interface IotTopicRuleKinesis {
    readonly partitionKey?: string;
    readonly roleArn: string;
    readonly streamName: string;
}
export interface IotTopicRuleLambda {
    readonly functionArn: string;
}
export interface IotTopicRuleRepublish {
    readonly qos?: number;
    readonly roleArn: string;
    readonly topic: string;
}
export interface IotTopicRuleS3 {
    readonly bucketName: string;
    readonly key: string;
    readonly roleArn: string;
}
export interface IotTopicRuleSns {
    readonly messageFormat?: string;
    readonly roleArn: string;
    readonly targetArn: string;
}
export interface IotTopicRuleSqs {
    readonly queueUrl: string;
    readonly roleArn: string;
    readonly useBase64: boolean;
}
export interface IotTopicRuleStepFunctions {
    readonly executionNamePrefix?: string;
    readonly roleArn: string;
    readonly stateMachineName: string;
}
export declare class IotTopicRule extends TerraformResource {
    constructor(scope: Construct, id: string, config: IotTopicRuleConfig);
    get arn(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _enabled;
    get enabled(): boolean;
    set enabled(value: boolean);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _sql;
    get sql(): string;
    set sql(value: string);
    private _sqlVersion;
    get sqlVersion(): string;
    set sqlVersion(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _cloudwatchAlarm?;
    get cloudwatchAlarm(): IotTopicRuleCloudwatchAlarm[] | undefined;
    set cloudwatchAlarm(value: IotTopicRuleCloudwatchAlarm[] | undefined);
    private _cloudwatchMetric?;
    get cloudwatchMetric(): IotTopicRuleCloudwatchMetric[] | undefined;
    set cloudwatchMetric(value: IotTopicRuleCloudwatchMetric[] | undefined);
    private _dynamodb?;
    get dynamodb(): IotTopicRuleDynamodb[] | undefined;
    set dynamodb(value: IotTopicRuleDynamodb[] | undefined);
    private _dynamodbv2?;
    get dynamodbv2(): IotTopicRuleDynamodbv2[] | undefined;
    set dynamodbv2(value: IotTopicRuleDynamodbv2[] | undefined);
    private _elasticsearch?;
    get elasticsearch(): IotTopicRuleElasticsearch[] | undefined;
    set elasticsearch(value: IotTopicRuleElasticsearch[] | undefined);
    private _errorAction?;
    get errorAction(): IotTopicRuleErrorAction[] | undefined;
    set errorAction(value: IotTopicRuleErrorAction[] | undefined);
    private _firehose?;
    get firehose(): IotTopicRuleFirehose[] | undefined;
    set firehose(value: IotTopicRuleFirehose[] | undefined);
    private _iotAnalytics?;
    get iotAnalytics(): IotTopicRuleIotAnalytics[] | undefined;
    set iotAnalytics(value: IotTopicRuleIotAnalytics[] | undefined);
    private _iotEvents?;
    get iotEvents(): IotTopicRuleIotEvents[] | undefined;
    set iotEvents(value: IotTopicRuleIotEvents[] | undefined);
    private _kinesis?;
    get kinesis(): IotTopicRuleKinesis[] | undefined;
    set kinesis(value: IotTopicRuleKinesis[] | undefined);
    private _lambda?;
    get lambda(): IotTopicRuleLambda[] | undefined;
    set lambda(value: IotTopicRuleLambda[] | undefined);
    private _republish?;
    get republish(): IotTopicRuleRepublish[] | undefined;
    set republish(value: IotTopicRuleRepublish[] | undefined);
    private _s3?;
    get s3(): IotTopicRuleS3[] | undefined;
    set s3(value: IotTopicRuleS3[] | undefined);
    private _sns?;
    get sns(): IotTopicRuleSns[] | undefined;
    set sns(value: IotTopicRuleSns[] | undefined);
    private _sqs?;
    get sqs(): IotTopicRuleSqs[] | undefined;
    set sqs(value: IotTopicRuleSqs[] | undefined);
    private _stepFunctions?;
    get stepFunctions(): IotTopicRuleStepFunctions[] | undefined;
    set stepFunctions(value: IotTopicRuleStepFunctions[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
