import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface KeyPairConfig extends TerraformMetaArguments {
    readonly keyName?: string;
    readonly keyNamePrefix?: string;
    readonly publicKey: string;
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class KeyPair extends TerraformResource {
    constructor(scope: Construct, id: string, config: KeyPairConfig);
    get arn(): string;
    get fingerprint(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _keyName?;
    get keyName(): string | undefined;
    set keyName(value: string | undefined);
    private _keyNamePrefix?;
    get keyNamePrefix(): string | undefined;
    set keyNamePrefix(value: string | undefined);
    get keyPairId(): string;
    private _publicKey;
    get publicKey(): string;
    set publicKey(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
