import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface KinesisAnalyticsApplicationConfig extends TerraformMetaArguments {
    readonly code?: string;
    readonly description?: string;
    readonly name: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** cloudwatch_logging_options block */
    readonly cloudwatchLoggingOptions?: KinesisAnalyticsApplicationCloudwatchLoggingOptions[];
    /** inputs block */
    readonly inputs?: KinesisAnalyticsApplicationInputs[];
    /** outputs block */
    readonly outputs?: KinesisAnalyticsApplicationOutputs[];
    /** reference_data_sources block */
    readonly referenceDataSources?: KinesisAnalyticsApplicationReferenceDataSources[];
}
export interface KinesisAnalyticsApplicationCloudwatchLoggingOptions {
    readonly logStreamArn: string;
    readonly roleArn: string;
}
export interface KinesisAnalyticsApplicationInputsKinesisFirehose {
    readonly resourceArn: string;
    readonly roleArn: string;
}
export interface KinesisAnalyticsApplicationInputsKinesisStream {
    readonly resourceArn: string;
    readonly roleArn: string;
}
export interface KinesisAnalyticsApplicationInputsParallelism {
    readonly count: number;
}
export interface KinesisAnalyticsApplicationInputsProcessingConfigurationLambda {
    readonly resourceArn: string;
    readonly roleArn: string;
}
export interface KinesisAnalyticsApplicationInputsProcessingConfiguration {
    /** lambda block */
    readonly lambda: KinesisAnalyticsApplicationInputsProcessingConfigurationLambda[];
}
export interface KinesisAnalyticsApplicationInputsSchemaRecordColumns {
    readonly mapping?: string;
    readonly name: string;
    readonly sqlType: string;
}
export interface KinesisAnalyticsApplicationInputsSchemaRecordFormatMappingParametersCsv {
    readonly recordColumnDelimiter: string;
    readonly recordRowDelimiter: string;
}
export interface KinesisAnalyticsApplicationInputsSchemaRecordFormatMappingParametersJson {
    readonly recordRowPath: string;
}
export interface KinesisAnalyticsApplicationInputsSchemaRecordFormatMappingParameters {
    /** csv block */
    readonly csv?: KinesisAnalyticsApplicationInputsSchemaRecordFormatMappingParametersCsv[];
    /** json block */
    readonly json?: KinesisAnalyticsApplicationInputsSchemaRecordFormatMappingParametersJson[];
}
export interface KinesisAnalyticsApplicationInputsSchemaRecordFormat {
    /** mapping_parameters block */
    readonly mappingParameters?: KinesisAnalyticsApplicationInputsSchemaRecordFormatMappingParameters[];
}
export interface KinesisAnalyticsApplicationInputsSchema {
    readonly recordEncoding?: string;
    /** record_columns block */
    readonly recordColumns: KinesisAnalyticsApplicationInputsSchemaRecordColumns[];
    /** record_format block */
    readonly recordFormat: KinesisAnalyticsApplicationInputsSchemaRecordFormat[];
}
export interface KinesisAnalyticsApplicationInputs {
    readonly namePrefix: string;
    /** kinesis_firehose block */
    readonly kinesisFirehose?: KinesisAnalyticsApplicationInputsKinesisFirehose[];
    /** kinesis_stream block */
    readonly kinesisStream?: KinesisAnalyticsApplicationInputsKinesisStream[];
    /** parallelism block */
    readonly parallelism?: KinesisAnalyticsApplicationInputsParallelism[];
    /** processing_configuration block */
    readonly processingConfiguration?: KinesisAnalyticsApplicationInputsProcessingConfiguration[];
    /** schema block */
    readonly schema: KinesisAnalyticsApplicationInputsSchema[];
}
export interface KinesisAnalyticsApplicationOutputsKinesisFirehose {
    readonly resourceArn: string;
    readonly roleArn: string;
}
export interface KinesisAnalyticsApplicationOutputsKinesisStream {
    readonly resourceArn: string;
    readonly roleArn: string;
}
export interface KinesisAnalyticsApplicationOutputsLambda {
    readonly resourceArn: string;
    readonly roleArn: string;
}
export interface KinesisAnalyticsApplicationOutputsSchema {
    readonly recordFormatType?: string;
}
export interface KinesisAnalyticsApplicationOutputs {
    readonly name: string;
    /** kinesis_firehose block */
    readonly kinesisFirehose?: KinesisAnalyticsApplicationOutputsKinesisFirehose[];
    /** kinesis_stream block */
    readonly kinesisStream?: KinesisAnalyticsApplicationOutputsKinesisStream[];
    /** lambda block */
    readonly lambda?: KinesisAnalyticsApplicationOutputsLambda[];
    /** schema block */
    readonly schema: KinesisAnalyticsApplicationOutputsSchema[];
}
export interface KinesisAnalyticsApplicationReferenceDataSourcesS3 {
    readonly bucketArn: string;
    readonly fileKey: string;
    readonly roleArn: string;
}
export interface KinesisAnalyticsApplicationReferenceDataSourcesSchemaRecordColumns {
    readonly mapping?: string;
    readonly name: string;
    readonly sqlType: string;
}
export interface KinesisAnalyticsApplicationReferenceDataSourcesSchemaRecordFormatMappingParametersCsv {
    readonly recordColumnDelimiter: string;
    readonly recordRowDelimiter: string;
}
export interface KinesisAnalyticsApplicationReferenceDataSourcesSchemaRecordFormatMappingParametersJson {
    readonly recordRowPath: string;
}
export interface KinesisAnalyticsApplicationReferenceDataSourcesSchemaRecordFormatMappingParameters {
    /** csv block */
    readonly csv?: KinesisAnalyticsApplicationReferenceDataSourcesSchemaRecordFormatMappingParametersCsv[];
    /** json block */
    readonly json?: KinesisAnalyticsApplicationReferenceDataSourcesSchemaRecordFormatMappingParametersJson[];
}
export interface KinesisAnalyticsApplicationReferenceDataSourcesSchemaRecordFormat {
    /** mapping_parameters block */
    readonly mappingParameters?: KinesisAnalyticsApplicationReferenceDataSourcesSchemaRecordFormatMappingParameters[];
}
export interface KinesisAnalyticsApplicationReferenceDataSourcesSchema {
    readonly recordEncoding?: string;
    /** record_columns block */
    readonly recordColumns: KinesisAnalyticsApplicationReferenceDataSourcesSchemaRecordColumns[];
    /** record_format block */
    readonly recordFormat: KinesisAnalyticsApplicationReferenceDataSourcesSchemaRecordFormat[];
}
export interface KinesisAnalyticsApplicationReferenceDataSources {
    readonly tableName: string;
    /** s3 block */
    readonly s3: KinesisAnalyticsApplicationReferenceDataSourcesS3[];
    /** schema block */
    readonly schema: KinesisAnalyticsApplicationReferenceDataSourcesSchema[];
}
export declare class KinesisAnalyticsApplication extends TerraformResource {
    constructor(scope: Construct, id: string, config: KinesisAnalyticsApplicationConfig);
    get arn(): string;
    private _code?;
    get code(): string | undefined;
    set code(value: string | undefined);
    get createTimestamp(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get lastUpdateTimestamp(): string;
    private _name;
    get name(): string;
    set name(value: string);
    get status(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get version(): number;
    private _cloudwatchLoggingOptions?;
    get cloudwatchLoggingOptions(): KinesisAnalyticsApplicationCloudwatchLoggingOptions[] | undefined;
    set cloudwatchLoggingOptions(value: KinesisAnalyticsApplicationCloudwatchLoggingOptions[] | undefined);
    private _inputs?;
    get inputs(): KinesisAnalyticsApplicationInputs[] | undefined;
    set inputs(value: KinesisAnalyticsApplicationInputs[] | undefined);
    private _outputs?;
    get outputs(): KinesisAnalyticsApplicationOutputs[] | undefined;
    set outputs(value: KinesisAnalyticsApplicationOutputs[] | undefined);
    private _referenceDataSources?;
    get referenceDataSources(): KinesisAnalyticsApplicationReferenceDataSources[] | undefined;
    set referenceDataSources(value: KinesisAnalyticsApplicationReferenceDataSources[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
