"use strict";
// https://www.terraform.io/docs/providers/aws/r/kinesis_analytics_application.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisAnalyticsApplication = void 0;
const cdktf_1 = require("cdktf");
// Resource
class KinesisAnalyticsApplication extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_kinesis_analytics_application',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._code = config.code;
        this._description = config.description;
        this._name = config.name;
        this._tags = config.tags;
        this._cloudwatchLoggingOptions = config.cloudwatchLoggingOptions;
        this._inputs = config.inputs;
        this._outputs = config.outputs;
        this._referenceDataSources = config.referenceDataSources;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // arn - computed: true, optional: false, required: true
    get arn() {
        return this.getStringAttribute('arn');
    }
    get code() {
        return this._code;
    }
    set code(value) {
        this._code = value;
    }
    // create_timestamp - computed: true, optional: false, required: true
    get createTimestamp() {
        return this.getStringAttribute('create_timestamp');
    }
    get description() {
        return this._description;
    }
    set description(value) {
        this._description = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    // last_update_timestamp - computed: true, optional: false, required: true
    get lastUpdateTimestamp() {
        return this.getStringAttribute('last_update_timestamp');
    }
    get name() {
        return this._name;
    }
    set name(value) {
        this._name = value;
    }
    // status - computed: true, optional: false, required: true
    get status() {
        return this.getStringAttribute('status');
    }
    get tags() {
        return this._tags;
    }
    set tags(value) {
        this._tags = value;
    }
    // version - computed: true, optional: false, required: true
    get version() {
        return this.getNumberAttribute('version');
    }
    get cloudwatchLoggingOptions() {
        return this._cloudwatchLoggingOptions;
    }
    set cloudwatchLoggingOptions(value) {
        this._cloudwatchLoggingOptions = value;
    }
    get inputs() {
        return this._inputs;
    }
    set inputs(value) {
        this._inputs = value;
    }
    get outputs() {
        return this._outputs;
    }
    set outputs(value) {
        this._outputs = value;
    }
    get referenceDataSources() {
        return this._referenceDataSources;
    }
    set referenceDataSources(value) {
        this._referenceDataSources = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            code: this._code,
            description: this._description,
            name: this._name,
            tags: this._tags,
            cloudwatch_logging_options: this._cloudwatchLoggingOptions,
            inputs: this._inputs,
            outputs: this._outputs,
            reference_data_sources: this._referenceDataSources,
        };
    }
}
exports.KinesisAnalyticsApplication = KinesisAnalyticsApplication;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoia2luZXNpcy1hbmFseXRpY3MtYXBwbGljYXRpb24uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMva2luZXNpcy1hbmFseXRpY3MtYXBwbGljYXRpb24udHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBLG1GQUFtRjtBQUNuRiwyQ0FBMkM7OztBQTBkM0MsaUNBQTBDO0FBd0oxQyxXQUFXO0FBRVgsTUFBYSwyQkFBNEIsU0FBUSx5QkFBaUI7SUFFaEUsY0FBYztJQUNkLGNBQWM7SUFDZCxjQUFjO0lBRWQsWUFBbUIsS0FBZ0IsRUFBRSxFQUFVLEVBQUUsTUFBeUM7UUFDeEYsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUU7WUFDZixxQkFBcUIsRUFBRSxtQ0FBbUM7WUFDMUQsMEJBQTBCLEVBQUU7Z0JBQzFCLFlBQVksRUFBRSxLQUFLO2FBQ3BCO1lBQ0QsUUFBUSxFQUFFLE1BQU0sQ0FBQyxRQUFRO1lBQ3pCLFNBQVMsRUFBRSxNQUFNLENBQUMsU0FBUztZQUMzQixLQUFLLEVBQUUsTUFBTSxDQUFDLEtBQUs7WUFDbkIsU0FBUyxFQUFFLE1BQU0sQ0FBQyxTQUFTO1NBQzVCLENBQUMsQ0FBQztRQUNILElBQUksQ0FBQyxLQUFLLEdBQUcsTUFBTSxDQUFDLElBQUksQ0FBQztRQUN6QixJQUFJLENBQUMsWUFBWSxHQUFHLE1BQU0sQ0FBQyxXQUFXLENBQUM7UUFDdkMsSUFBSSxDQUFDLEtBQUssR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDO1FBQ3pCLElBQUksQ0FBQyxLQUFLLEdBQUcsTUFBTSxDQUFDLElBQUksQ0FBQztRQUN6QixJQUFJLENBQUMseUJBQXlCLEdBQUcsTUFBTSxDQUFDLHdCQUF3QixDQUFDO1FBQ2pFLElBQUksQ0FBQyxPQUFPLEdBQUcsTUFBTSxDQUFDLE1BQU0sQ0FBQztRQUM3QixJQUFJLENBQUMsUUFBUSxHQUFHLE1BQU0sQ0FBQyxPQUFPLENBQUM7UUFDL0IsSUFBSSxDQUFDLHFCQUFxQixHQUFHLE1BQU0sQ0FBQyxvQkFBb0IsQ0FBQztJQUMzRCxDQUFDO0lBRUQsYUFBYTtJQUNiLGFBQWE7SUFDYixhQUFhO0lBRWIsd0RBQXdEO0lBQ3hELElBQVcsR0FBRztRQUNaLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLEtBQUssQ0FBQyxDQUFDO0lBQ3hDLENBQUM7SUFJRCxJQUFXLElBQUk7UUFDYixPQUFPLElBQUksQ0FBQyxLQUFLLENBQUM7SUFDcEIsQ0FBQztJQUNELElBQVcsSUFBSSxDQUFDLEtBQXlCO1FBQ3ZDLElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDO0lBQ3JCLENBQUM7SUFFRCxxRUFBcUU7SUFDckUsSUFBVyxlQUFlO1FBQ3hCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLGtCQUFrQixDQUFDLENBQUM7SUFDckQsQ0FBQztJQUlELElBQVcsV0FBVztRQUNwQixPQUFPLElBQUksQ0FBQyxZQUFZLENBQUM7SUFDM0IsQ0FBQztJQUNELElBQVcsV0FBVyxDQUFDLEtBQXlCO1FBQzlDLElBQUksQ0FBQyxZQUFZLEdBQUcsS0FBSyxDQUFDO0lBQzVCLENBQUM7SUFJRCxJQUFXLEVBQUU7O1FBQ1gsYUFBTyxJQUFJLENBQUMsR0FBRyxtQ0FBSSxJQUFJLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLENBQUM7SUFDbkQsQ0FBQztJQUNELElBQVcsRUFBRSxDQUFDLEtBQXlCO1FBQ3JDLElBQUksQ0FBQyxHQUFHLEdBQUcsS0FBSyxDQUFDO0lBQ25CLENBQUM7SUFFRCwwRUFBMEU7SUFDMUUsSUFBVyxtQkFBbUI7UUFDNUIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsdUJBQXVCLENBQUMsQ0FBQztJQUMxRCxDQUFDO0lBSUQsSUFBVyxJQUFJO1FBQ2IsT0FBTyxJQUFJLENBQUMsS0FBSyxDQUFDO0lBQ3BCLENBQUM7SUFDRCxJQUFXLElBQUksQ0FBQyxLQUFhO1FBQzNCLElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDO0lBQ3JCLENBQUM7SUFFRCwyREFBMkQ7SUFDM0QsSUFBVyxNQUFNO1FBQ2YsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsUUFBUSxDQUFDLENBQUM7SUFDM0MsQ0FBQztJQUlELElBQVcsSUFBSTtRQUNiLE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQztJQUNwQixDQUFDO0lBQ0QsSUFBVyxJQUFJLENBQUMsS0FBNEM7UUFDMUQsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUM7SUFDckIsQ0FBQztJQUVELDREQUE0RDtJQUM1RCxJQUFXLE9BQU87UUFDaEIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDNUMsQ0FBQztJQUlELElBQVcsd0JBQXdCO1FBQ2pDLE9BQU8sSUFBSSxDQUFDLHlCQUF5QixDQUFDO0lBQ3hDLENBQUM7SUFDRCxJQUFXLHdCQUF3QixDQUFDLEtBQXdFO1FBQzFHLElBQUksQ0FBQyx5QkFBeUIsR0FBRyxLQUFLLENBQUM7SUFDekMsQ0FBQztJQUlELElBQVcsTUFBTTtRQUNmLE9BQU8sSUFBSSxDQUFDLE9BQU8sQ0FBQztJQUN0QixDQUFDO0lBQ0QsSUFBVyxNQUFNLENBQUMsS0FBc0Q7UUFDdEUsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUM7SUFDdkIsQ0FBQztJQUlELElBQVcsT0FBTztRQUNoQixPQUFPLElBQUksQ0FBQyxRQUFRLENBQUM7SUFDdkIsQ0FBQztJQUNELElBQVcsT0FBTyxDQUFDLEtBQXVEO1FBQ3hFLElBQUksQ0FBQyxRQUFRLEdBQUcsS0FBSyxDQUFDO0lBQ3hCLENBQUM7SUFJRCxJQUFXLG9CQUFvQjtRQUM3QixPQUFPLElBQUksQ0FBQyxxQkFBcUIsQ0FBQztJQUNwQyxDQUFDO0lBQ0QsSUFBVyxvQkFBb0IsQ0FBQyxLQUFvRTtRQUNsRyxJQUFJLENBQUMscUJBQXFCLEdBQUcsS0FBSyxDQUFDO0lBQ3JDLENBQUM7SUFFRCxZQUFZO0lBQ1osWUFBWTtJQUNaLFlBQVk7SUFFTCxvQkFBb0I7UUFDekIsT0FBTztZQUNMLElBQUksRUFBRSxJQUFJLENBQUMsS0FBSztZQUNoQixXQUFXLEVBQUUsSUFBSSxDQUFDLFlBQVk7WUFDOUIsSUFBSSxFQUFFLElBQUksQ0FBQyxLQUFLO1lBQ2hCLElBQUksRUFBRSxJQUFJLENBQUMsS0FBSztZQUNoQiwwQkFBMEIsRUFBRSxJQUFJLENBQUMseUJBQXlCO1lBQzFELE1BQU0sRUFBRSxJQUFJLENBQUMsT0FBTztZQUNwQixPQUFPLEVBQUUsSUFBSSxDQUFDLFFBQVE7WUFDdEIsc0JBQXNCLEVBQUUsSUFBSSxDQUFDLHFCQUFxQjtTQUNuRCxDQUFDO0lBQ0osQ0FBQztDQUNGO0FBekpELGtFQXlKQyIsInNvdXJjZXNDb250ZW50IjpbIi8vIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9hd3Mvci9raW5lc2lzX2FuYWx5dGljc19hcHBsaWNhdGlvbi5odG1sXG4vLyBnZW5lcmF0ZWQgZnJvbSB0ZXJyYWZvcm0gcmVzb3VyY2Ugc2NoZW1hXG5cbi8qXG57XG4gIFwidmVyc2lvblwiOiAwLFxuICBcImJsb2NrXCI6IHtcbiAgICBcImF0dHJpYnV0ZXNcIjoge1xuICAgICAgXCJhcm5cIjoge1xuICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgXCJjb21wdXRlZFwiOiB0cnVlXG4gICAgICB9LFxuICAgICAgXCJjb2RlXCI6IHtcbiAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwiY3JlYXRlX3RpbWVzdGFtcFwiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICBcImNvbXB1dGVkXCI6IHRydWVcbiAgICAgIH0sXG4gICAgICBcImRlc2NyaXB0aW9uXCI6IHtcbiAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwiaWRcIjoge1xuICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlLFxuICAgICAgICBcImNvbXB1dGVkXCI6IHRydWVcbiAgICAgIH0sXG4gICAgICBcImxhc3RfdXBkYXRlX3RpbWVzdGFtcFwiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICBcImNvbXB1dGVkXCI6IHRydWVcbiAgICAgIH0sXG4gICAgICBcIm5hbWVcIjoge1xuICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgXCJyZXF1aXJlZFwiOiB0cnVlXG4gICAgICB9LFxuICAgICAgXCJzdGF0dXNcIjoge1xuICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgXCJjb21wdXRlZFwiOiB0cnVlXG4gICAgICB9LFxuICAgICAgXCJ0YWdzXCI6IHtcbiAgICAgICAgXCJ0eXBlXCI6IFtcbiAgICAgICAgICBcIm1hcFwiLFxuICAgICAgICAgIFwic3RyaW5nXCJcbiAgICAgICAgXSxcbiAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICB9LFxuICAgICAgXCJ2ZXJzaW9uXCI6IHtcbiAgICAgICAgXCJ0eXBlXCI6IFwibnVtYmVyXCIsXG4gICAgICAgIFwiY29tcHV0ZWRcIjogdHJ1ZVxuICAgICAgfVxuICAgIH0sXG4gICAgXCJibG9ja190eXBlc1wiOiB7XG4gICAgICBcImNsb3Vkd2F0Y2hfbG9nZ2luZ19vcHRpb25zXCI6IHtcbiAgICAgICAgXCJuZXN0aW5nX21vZGVcIjogXCJsaXN0XCIsXG4gICAgICAgIFwiYmxvY2tcIjoge1xuICAgICAgICAgIFwiYXR0cmlidXRlc1wiOiB7XG4gICAgICAgICAgICBcImlkXCI6IHtcbiAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgICAgICAgIFwiY29tcHV0ZWRcIjogdHJ1ZVxuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIFwibG9nX3N0cmVhbV9hcm5cIjoge1xuICAgICAgICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgICAgICAgXCJyZXF1aXJlZFwiOiB0cnVlXG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAgXCJyb2xlX2FyblwiOiB7XG4gICAgICAgICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICAgICAgICBcInJlcXVpcmVkXCI6IHRydWVcbiAgICAgICAgICAgIH1cbiAgICAgICAgICB9XG4gICAgICAgIH0sXG4gICAgICAgIFwibWF4X2l0ZW1zXCI6IDFcbiAgICAgIH0sXG4gICAgICBcImlucHV0c1wiOiB7XG4gICAgICAgIFwibmVzdGluZ19tb2RlXCI6IFwibGlzdFwiLFxuICAgICAgICBcImJsb2NrXCI6IHtcbiAgICAgICAgICBcImF0dHJpYnV0ZXNcIjoge1xuICAgICAgICAgICAgXCJpZFwiOiB7XG4gICAgICAgICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICAgICAgICBcImNvbXB1dGVkXCI6IHRydWVcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICBcIm5hbWVfcHJlZml4XCI6IHtcbiAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgICAgICAgIFwicmVxdWlyZWRcIjogdHJ1ZVxuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIFwic3RhcnRpbmdfcG9zaXRpb25fY29uZmlndXJhdGlvblwiOiB7XG4gICAgICAgICAgICAgIFwidHlwZVwiOiBbXG4gICAgICAgICAgICAgICAgXCJsaXN0XCIsXG4gICAgICAgICAgICAgICAgW1xuICAgICAgICAgICAgICAgICAgXCJvYmplY3RcIixcbiAgICAgICAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgICAgICAgXCJzdGFydGluZ19wb3NpdGlvblwiOiBcInN0cmluZ1wiXG4gICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgXVxuICAgICAgICAgICAgICBdLFxuICAgICAgICAgICAgICBcImNvbXB1dGVkXCI6IHRydWVcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICBcInN0cmVhbV9uYW1lc1wiOiB7XG4gICAgICAgICAgICAgIFwidHlwZVwiOiBbXG4gICAgICAgICAgICAgICAgXCJzZXRcIixcbiAgICAgICAgICAgICAgICBcInN0cmluZ1wiXG4gICAgICAgICAgICAgIF0sXG4gICAgICAgICAgICAgIFwiY29tcHV0ZWRcIjogdHJ1ZVxuICAgICAgICAgICAgfVxuICAgICAgICAgIH0sXG4gICAgICAgICAgXCJibG9ja190eXBlc1wiOiB7XG4gICAgICAgICAgICBcImtpbmVzaXNfZmlyZWhvc2VcIjoge1xuICAgICAgICAgICAgICBcIm5lc3RpbmdfbW9kZVwiOiBcImxpc3RcIixcbiAgICAgICAgICAgICAgXCJibG9ja1wiOiB7XG4gICAgICAgICAgICAgICAgXCJhdHRyaWJ1dGVzXCI6IHtcbiAgICAgICAgICAgICAgICAgIFwicmVzb3VyY2VfYXJuXCI6IHtcbiAgICAgICAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgICAgICAgICAgICAgIFwicmVxdWlyZWRcIjogdHJ1ZVxuICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgIFwicm9sZV9hcm5cIjoge1xuICAgICAgICAgICAgICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgICAgICAgICAgICAgXCJyZXF1aXJlZFwiOiB0cnVlXG4gICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICBcIm1heF9pdGVtc1wiOiAxXG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAgXCJraW5lc2lzX3N0cmVhbVwiOiB7XG4gICAgICAgICAgICAgIFwibmVzdGluZ19tb2RlXCI6IFwibGlzdFwiLFxuICAgICAgICAgICAgICBcImJsb2NrXCI6IHtcbiAgICAgICAgICAgICAgICBcImF0dHJpYnV0ZXNcIjoge1xuICAgICAgICAgICAgICAgICAgXCJyZXNvdXJjZV9hcm5cIjoge1xuICAgICAgICAgICAgICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgICAgICAgICAgICAgXCJyZXF1aXJlZFwiOiB0cnVlXG4gICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgXCJyb2xlX2FyblwiOiB7XG4gICAgICAgICAgICAgICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICAgICAgICAgICAgICBcInJlcXVpcmVkXCI6IHRydWVcbiAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgIFwibWF4X2l0ZW1zXCI6IDFcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICBcInBhcmFsbGVsaXNtXCI6IHtcbiAgICAgICAgICAgICAgXCJuZXN0aW5nX21vZGVcIjogXCJsaXN0XCIsXG4gICAgICAgICAgICAgIFwiYmxvY2tcIjoge1xuICAgICAgICAgICAgICAgIFwiYXR0cmlidXRlc1wiOiB7XG4gICAgICAgICAgICAgICAgICBcImNvdW50XCI6IHtcbiAgICAgICAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwibnVtYmVyXCIsXG4gICAgICAgICAgICAgICAgICAgIFwicmVxdWlyZWRcIjogdHJ1ZVxuICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgXCJtYXhfaXRlbXNcIjogMVxuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIFwicHJvY2Vzc2luZ19jb25maWd1cmF0aW9uXCI6IHtcbiAgICAgICAgICAgICAgXCJuZXN0aW5nX21vZGVcIjogXCJsaXN0XCIsXG4gICAgICAgICAgICAgIFwiYmxvY2tcIjoge1xuICAgICAgICAgICAgICAgIFwiYmxvY2tfdHlwZXNcIjoge1xuICAgICAgICAgICAgICAgICAgXCJsYW1iZGFcIjoge1xuICAgICAgICAgICAgICAgICAgICBcIm5lc3RpbmdfbW9kZVwiOiBcImxpc3RcIixcbiAgICAgICAgICAgICAgICAgICAgXCJibG9ja1wiOiB7XG4gICAgICAgICAgICAgICAgICAgICAgXCJhdHRyaWJ1dGVzXCI6IHtcbiAgICAgICAgICAgICAgICAgICAgICAgIFwicmVzb3VyY2VfYXJuXCI6IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgICAgICAgICAgICAgICAgICAgIFwicmVxdWlyZWRcIjogdHJ1ZVxuICAgICAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgICAgIFwicm9sZV9hcm5cIjoge1xuICAgICAgICAgICAgICAgICAgICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgICAgICAgICAgICAgICAgICAgXCJyZXF1aXJlZFwiOiB0cnVlXG4gICAgICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICBcIm1pbl9pdGVtc1wiOiAxLFxuICAgICAgICAgICAgICAgICAgICBcIm1heF9pdGVtc1wiOiAxXG4gICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICBcIm1heF9pdGVtc1wiOiAxXG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAgXCJzY2hlbWFcIjoge1xuICAgICAgICAgICAgICBcIm5lc3RpbmdfbW9kZVwiOiBcImxpc3RcIixcbiAgICAgICAgICAgICAgXCJibG9ja1wiOiB7XG4gICAgICAgICAgICAgICAgXCJhdHRyaWJ1dGVzXCI6IHtcbiAgICAgICAgICAgICAgICAgIFwicmVjb3JkX2VuY29kaW5nXCI6IHtcbiAgICAgICAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgICAgICAgICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgXCJibG9ja190eXBlc1wiOiB7XG4gICAgICAgICAgICAgICAgICBcInJlY29yZF9jb2x1bW5zXCI6IHtcbiAgICAgICAgICAgICAgICAgICAgXCJuZXN0aW5nX21vZGVcIjogXCJsaXN0XCIsXG4gICAgICAgICAgICAgICAgICAgIFwiYmxvY2tcIjoge1xuICAgICAgICAgICAgICAgICAgICAgIFwiYXR0cmlidXRlc1wiOiB7XG4gICAgICAgICAgICAgICAgICAgICAgICBcIm1hcHBpbmdcIjoge1xuICAgICAgICAgICAgICAgICAgICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgICAgICAgICAgICAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICAgICAgXCJuYW1lXCI6IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgICAgICAgICAgICAgICAgICAgIFwicmVxdWlyZWRcIjogdHJ1ZVxuICAgICAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgICAgIFwic3FsX3R5cGVcIjoge1xuICAgICAgICAgICAgICAgICAgICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgICAgICAgICAgICAgICAgICAgXCJyZXF1aXJlZFwiOiB0cnVlXG4gICAgICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICBcIm1pbl9pdGVtc1wiOiAxXG4gICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgXCJyZWNvcmRfZm9ybWF0XCI6IHtcbiAgICAgICAgICAgICAgICAgICAgXCJuZXN0aW5nX21vZGVcIjogXCJsaXN0XCIsXG4gICAgICAgICAgICAgICAgICAgIFwiYmxvY2tcIjoge1xuICAgICAgICAgICAgICAgICAgICAgIFwiYXR0cmlidXRlc1wiOiB7XG4gICAgICAgICAgICAgICAgICAgICAgICBcInJlY29yZF9mb3JtYXRfdHlwZVwiOiB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICAgICAgICAgICAgICAgICAgICBcImNvbXB1dGVkXCI6IHRydWVcbiAgICAgICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICAgIFwiYmxvY2tfdHlwZXNcIjoge1xuICAgICAgICAgICAgICAgICAgICAgICAgXCJtYXBwaW5nX3BhcmFtZXRlcnNcIjoge1xuICAgICAgICAgICAgICAgICAgICAgICAgICBcIm5lc3RpbmdfbW9kZVwiOiBcImxpc3RcIixcbiAgICAgICAgICAgICAgICAgICAgICAgICAgXCJibG9ja1wiOiB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJibG9ja190eXBlc1wiOiB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcImNzdlwiOiB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwibmVzdGluZ19tb2RlXCI6IFwibGlzdFwiLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcImJsb2NrXCI6IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcImF0dHJpYnV0ZXNcIjoge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJyZWNvcmRfY29sdW1uX2RlbGltaXRlclwiOiB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcInJlcXVpcmVkXCI6IHRydWVcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcInJlY29yZF9yb3dfZGVsaW1pdGVyXCI6IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwicmVxdWlyZWRcIjogdHJ1ZVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJtYXhfaXRlbXNcIjogMVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwianNvblwiOiB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwibmVzdGluZ19tb2RlXCI6IFwibGlzdFwiLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcImJsb2NrXCI6IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcImF0dHJpYnV0ZXNcIjoge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJyZWNvcmRfcm93X3BhdGhcIjoge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJyZXF1aXJlZFwiOiB0cnVlXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcIm1heF9pdGVtc1wiOiAxXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICAgICAgICBcIm1heF9pdGVtc1wiOiAxXG4gICAgICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICBcIm1pbl9pdGVtc1wiOiAxLFxuICAgICAgICAgICAgICAgICAgICBcIm1heF9pdGVtc1wiOiAxXG4gICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICBcIm1pbl9pdGVtc1wiOiAxLFxuICAgICAgICAgICAgICBcIm1heF9pdGVtc1wiOiAxXG4gICAgICAgICAgICB9XG4gICAgICAgICAgfVxuICAgICAgICB9LFxuICAgICAgICBcIm1heF9pdGVtc1wiOiAxXG4gICAgICB9LFxuICAgICAgXCJvdXRwdXRzXCI6IHtcbiAgICAgICAgXCJuZXN0aW5nX21vZGVcIjogXCJsaXN0XCIsXG4gICAgICAgIFwiYmxvY2tcIjoge1xuICAgICAgICAgIFwiYXR0cmlidXRlc1wiOiB7XG4gICAgICAgICAgICBcImlkXCI6IHtcbiAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgICAgICAgIFwiY29tcHV0ZWRcIjogdHJ1ZVxuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIFwibmFtZVwiOiB7XG4gICAgICAgICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICAgICAgICBcInJlcXVpcmVkXCI6IHRydWVcbiAgICAgICAgICAgIH1cbiAgICAgICAgICB9LFxuICAgICAgICAgIFwiYmxvY2tfdHlwZXNcIjoge1xuICAgICAgICAgICAgXCJraW5lc2lzX2ZpcmVob3NlXCI6IHtcbiAgICAgICAgICAgICAgXCJuZXN0aW5nX21vZGVcIjogXCJsaXN0XCIsXG4gICAgICAgICAgICAgIFwiYmxvY2tcIjoge1xuICAgICAgICAgICAgICAgIFwiYXR0cmlidXRlc1wiOiB7XG4gICAgICAgICAgICAgICAgICBcInJlc291cmNlX2FyblwiOiB7XG4gICAgICAgICAgICAgICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICAgICAgICAgICAgICBcInJlcXVpcmVkXCI6IHRydWVcbiAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICBcInJvbGVfYXJuXCI6IHtcbiAgICAgICAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgICAgICAgICAgICAgIFwicmVxdWlyZWRcIjogdHJ1ZVxuICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgXCJtYXhfaXRlbXNcIjogMVxuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIFwia2luZXNpc19zdHJlYW1cIjoge1xuICAgICAgICAgICAgICBcIm5lc3RpbmdfbW9kZVwiOiBcImxpc3RcIixcbiAgICAgICAgICAgICAgXCJibG9ja1wiOiB7XG4gICAgICAgICAgICAgICAgXCJhdHRyaWJ1dGVzXCI6IHtcbiAgICAgICAgICAgICAgICAgIFwicmVzb3VyY2VfYXJuXCI6IHtcbiAgICAgICAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgICAgICAgICAgICAgIFwicmVxdWlyZWRcIjogdHJ1ZVxuICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgIFwicm9sZV9hcm5cIjoge1xuICAgICAgICAgICAgICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgICAgICAgICAgICAgXCJyZXF1aXJlZFwiOiB0cnVlXG4gICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICBcIm1heF9pdGVtc1wiOiAxXG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAgXCJsYW1iZGFcIjoge1xuICAgICAgICAgICAgICBcIm5lc3RpbmdfbW9kZVwiOiBcImxpc3RcIixcbiAgICAgICAgICAgICAgXCJibG9ja1wiOiB7XG4gICAgICAgICAgICAgICAgXCJhdHRyaWJ1dGVzXCI6IHtcbiAgICAgICAgICAgICAgICAgIFwicmVzb3VyY2VfYXJuXCI6IHtcbiAgICAgICAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgICAgICAgICAgICAgIFwicmVxdWlyZWRcIjogdHJ1ZVxuICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgIFwicm9sZV9hcm5cIjoge1xuICAgICAgICAgICAgICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgICAgICAgICAgICAgXCJyZXF1aXJlZFwiOiB0cnVlXG4gICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICBcIm1heF9pdGVtc1wiOiAxXG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAgXCJzY2hlbWFcIjoge1xuICAgICAgICAgICAgICBcIm5lc3RpbmdfbW9kZVwiOiBcImxpc3RcIixcbiAgICAgICAgICAgICAgXCJibG9ja1wiOiB7XG4gICAgICAgICAgICAgICAgXCJhdHRyaWJ1dGVzXCI6IHtcbiAgICAgICAgICAgICAgICAgIFwicmVjb3JkX2Zvcm1hdF90eXBlXCI6IHtcbiAgICAgICAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgICAgICAgICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgXCJtaW5faXRlbXNcIjogMSxcbiAgICAgICAgICAgICAgXCJtYXhfaXRlbXNcIjogMVxuICAgICAgICAgICAgfVxuICAgICAgICAgIH1cbiAgICAgICAgfSxcbiAgICAgICAgXCJtYXhfaXRlbXNcIjogM1xuICAgICAgfSxcbiAgICAgIFwicmVmZXJlbmNlX2RhdGFfc291cmNlc1wiOiB7XG4gICAgICAgIFwibmVzdGluZ19tb2RlXCI6IFwibGlzdFwiLFxuICAgICAgICBcImJsb2NrXCI6IHtcbiAgICAgICAgICBcImF0dHJpYnV0ZXNcIjoge1xuICAgICAgICAgICAgXCJpZFwiOiB7XG4gICAgICAgICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICAgICAgICBcImNvbXB1dGVkXCI6IHRydWVcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICBcInRhYmxlX25hbWVcIjoge1xuICAgICAgICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgICAgICAgXCJyZXF1aXJlZFwiOiB0cnVlXG4gICAgICAgICAgICB9XG4gICAgICAgICAgfSxcbiAgICAgICAgICBcImJsb2NrX3R5cGVzXCI6IHtcbiAgICAgICAgICAgIFwiczNcIjoge1xuICAgICAgICAgICAgICBcIm5lc3RpbmdfbW9kZVwiOiBcImxpc3RcIixcbiAgICAgICAgICAgICAgXCJibG9ja1wiOiB7XG4gICAgICAgICAgICAgICAgXCJhdHRyaWJ1dGVzXCI6IHtcbiAgICAgICAgICAgICAgICAgIFwiYnVja2V0X2FyblwiOiB7XG4gICAgICAgICAgICAgICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICAgICAgICAgICAgICBcInJlcXVpcmVkXCI6IHRydWVcbiAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICBcImZpbGVfa2V5XCI6IHtcbiAgICAgICAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgICAgICAgICAgICAgIFwicmVxdWlyZWRcIjogdHJ1ZVxuICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgIFwicm9sZV9hcm5cIjoge1xuICAgICAgICAgICAgICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgICAgICAgICAgICAgXCJyZXF1aXJlZFwiOiB0cnVlXG4gICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICBcIm1pbl9pdGVtc1wiOiAxLFxuICAgICAgICAgICAgICBcIm1heF9pdGVtc1wiOiAxXG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAgXCJzY2hlbWFcIjoge1xuICAgICAgICAgICAgICBcIm5lc3RpbmdfbW9kZVwiOiBcImxpc3RcIixcbiAgICAgICAgICAgICAgXCJibG9ja1wiOiB7XG4gICAgICAgICAgICAgICAgXCJhdHRyaWJ1dGVzXCI6IHtcbiAgICAgICAgICAgICAgICAgIFwicmVjb3JkX2VuY29kaW5nXCI6IHtcbiAgICAgICAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgICAgICAgICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgXCJibG9ja190eXBlc1wiOiB7XG4gICAgICAgICAgICAgICAgICBcInJlY29yZF9jb2x1bW5zXCI6IHtcbiAgICAgICAgICAgICAgICAgICAgXCJuZXN0aW5nX21vZGVcIjogXCJsaXN0XCIsXG4gICAgICAgICAgICAgICAgICAgIFwiYmxvY2tcIjoge1xuICAgICAgICAgICAgICAgICAgICAgIFwiYXR0cmlidXRlc1wiOiB7XG4gICAgICAgICAgICAgICAgICAgICAgICBcIm1hcHBpbmdcIjoge1xuICAgICAgICAgICAgICAgICAgICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgICAgICAgICAgICAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICAgICAgXCJuYW1lXCI6IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgICAgICAgICAgICAgICAgICAgIFwicmVxdWlyZWRcIjogdHJ1ZVxuICAgICAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgICAgIFwic3FsX3R5cGVcIjoge1xuICAgICAgICAgICAgICAgICAgICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgICAgICAgICAgICAgICAgICAgXCJyZXF1aXJlZFwiOiB0cnVlXG4gICAgICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICBcIm1pbl9pdGVtc1wiOiAxXG4gICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgXCJyZWNvcmRfZm9ybWF0XCI6IHtcbiAgICAgICAgICAgICAgICAgICAgXCJuZXN0aW5nX21vZGVcIjogXCJsaXN0XCIsXG4gICAgICAgICAgICAgICAgICAgIFwiYmxvY2tcIjoge1xuICAgICAgICAgICAgICAgICAgICAgIFwiYXR0cmlidXRlc1wiOiB7XG4gICAgICAgICAgICAgICAgICAgICAgICBcInJlY29yZF9mb3JtYXRfdHlwZVwiOiB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICAgICAgICAgICAgICAgICAgICBcImNvbXB1dGVkXCI6IHRydWVcbiAgICAgICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICAgIFwiYmxvY2tfdHlwZXNcIjoge1xuICAgICAgICAgICAgICAgICAgICAgICAgXCJtYXBwaW5nX3BhcmFtZXRlcnNcIjoge1xuICAgICAgICAgICAgICAgICAgICAgICAgICBcIm5lc3RpbmdfbW9kZVwiOiBcImxpc3RcIixcbiAgICAgICAgICAgICAgICAgICAgICAgICAgXCJibG9ja1wiOiB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJibG9ja190eXBlc1wiOiB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcImNzdlwiOiB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwibmVzdGluZ19tb2RlXCI6IFwibGlzdFwiLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcImJsb2NrXCI6IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcImF0dHJpYnV0ZXNcIjoge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJyZWNvcmRfY29sdW1uX2RlbGltaXRlclwiOiB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcInJlcXVpcmVkXCI6IHRydWVcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcInJlY29yZF9yb3dfZGVsaW1pdGVyXCI6IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwicmVxdWlyZWRcIjogdHJ1ZVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJtYXhfaXRlbXNcIjogMVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwianNvblwiOiB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwibmVzdGluZ19tb2RlXCI6IFwibGlzdFwiLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcImJsb2NrXCI6IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcImF0dHJpYnV0ZXNcIjoge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJyZWNvcmRfcm93X3BhdGhcIjoge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJyZXF1aXJlZFwiOiB0cnVlXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcIm1heF9pdGVtc1wiOiAxXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICAgICAgICBcIm1heF9pdGVtc1wiOiAxXG4gICAgICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICBcIm1pbl9pdGVtc1wiOiAxLFxuICAgICAgICAgICAgICAgICAgICBcIm1heF9pdGVtc1wiOiAxXG4gICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICBcIm1pbl9pdGVtc1wiOiAxLFxuICAgICAgICAgICAgICBcIm1heF9pdGVtc1wiOiAxXG4gICAgICAgICAgICB9XG4gICAgICAgICAgfVxuICAgICAgICB9LFxuICAgICAgICBcIm1heF9pdGVtc1wiOiAxXG4gICAgICB9XG4gICAgfVxuICB9XG59XG4qL1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBUZXJyYWZvcm1SZXNvdXJjZSB9IGZyb20gJ2Nka3RmJztcbmltcG9ydCB7IFRlcnJhZm9ybU1ldGFBcmd1bWVudHMgfSBmcm9tICdjZGt0Zic7XG5cbi8vIENvbmZpZ3VyYXRpb25cblxuZXhwb3J0IGludGVyZmFjZSBLaW5lc2lzQW5hbHl0aWNzQXBwbGljYXRpb25Db25maWcgZXh0ZW5kcyBUZXJyYWZvcm1NZXRhQXJndW1lbnRzIHtcbiAgcmVhZG9ubHkgY29kZT86IHN0cmluZztcbiAgcmVhZG9ubHkgZGVzY3JpcHRpb24/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IG5hbWU6IHN0cmluZztcbiAgcmVhZG9ubHkgdGFncz86IHsgW2tleTogc3RyaW5nXTogc3RyaW5nIH07XG4gIC8qKiBjbG91ZHdhdGNoX2xvZ2dpbmdfb3B0aW9ucyBibG9jayAqL1xuICByZWFkb25seSBjbG91ZHdhdGNoTG9nZ2luZ09wdGlvbnM/OiBLaW5lc2lzQW5hbHl0aWNzQXBwbGljYXRpb25DbG91ZHdhdGNoTG9nZ2luZ09wdGlvbnNbXTtcbiAgLyoqIGlucHV0cyBibG9jayAqL1xuICByZWFkb25seSBpbnB1dHM/OiBLaW5lc2lzQW5hbHl0aWNzQXBwbGljYXRpb25JbnB1dHNbXTtcbiAgLyoqIG91dHB1dHMgYmxvY2sgKi9cbiAgcmVhZG9ubHkgb3V0cHV0cz86IEtpbmVzaXNBbmFseXRpY3NBcHBsaWNhdGlvbk91dHB1dHNbXTtcbiAgLyoqIHJlZmVyZW5jZV9kYXRhX3NvdXJjZXMgYmxvY2sgKi9cbiAgcmVhZG9ubHkgcmVmZXJlbmNlRGF0YVNvdXJjZXM/OiBLaW5lc2lzQW5hbHl0aWNzQXBwbGljYXRpb25SZWZlcmVuY2VEYXRhU291cmNlc1tdO1xufVxuZXhwb3J0IGludGVyZmFjZSBLaW5lc2lzQW5hbHl0aWNzQXBwbGljYXRpb25DbG91ZHdhdGNoTG9nZ2luZ09wdGlvbnMge1xuICByZWFkb25seSBsb2dTdHJlYW1Bcm46IHN0cmluZztcbiAgcmVhZG9ubHkgcm9sZUFybjogc3RyaW5nO1xufVxuZXhwb3J0IGludGVyZmFjZSBLaW5lc2lzQW5hbHl0aWNzQXBwbGljYXRpb25JbnB1dHNLaW5lc2lzRmlyZWhvc2Uge1xuICByZWFkb25seSByZXNvdXJjZUFybjogc3RyaW5nO1xuICByZWFkb25seSByb2xlQXJuOiBzdHJpbmc7XG59XG5leHBvcnQgaW50ZXJmYWNlIEtpbmVzaXNBbmFseXRpY3NBcHBsaWNhdGlvbklucHV0c0tpbmVzaXNTdHJlYW0ge1xuICByZWFkb25seSByZXNvdXJjZUFybjogc3RyaW5nO1xuICByZWFkb25seSByb2xlQXJuOiBzdHJpbmc7XG59XG5leHBvcnQgaW50ZXJmYWNlIEtpbmVzaXNBbmFseXRpY3NBcHBsaWNhdGlvbklucHV0c1BhcmFsbGVsaXNtIHtcbiAgcmVhZG9ubHkgY291bnQ6IG51bWJlcjtcbn1cbmV4cG9ydCBpbnRlcmZhY2UgS2luZXNpc0FuYWx5dGljc0FwcGxpY2F0aW9uSW5wdXRzUHJvY2Vzc2luZ0NvbmZpZ3VyYXRpb25MYW1iZGEge1xuICByZWFkb25seSByZXNvdXJjZUFybjogc3RyaW5nO1xuICByZWFkb25seSByb2xlQXJuOiBzdHJpbmc7XG59XG5leHBvcnQgaW50ZXJmYWNlIEtpbmVzaXNBbmFseXRpY3NBcHBsaWNhdGlvbklucHV0c1Byb2Nlc3NpbmdDb25maWd1cmF0aW9uIHtcbiAgLyoqIGxhbWJkYSBibG9jayAqL1xuICByZWFkb25seSBsYW1iZGE6IEtpbmVzaXNBbmFseXRpY3NBcHBsaWNhdGlvbklucHV0c1Byb2Nlc3NpbmdDb25maWd1cmF0aW9uTGFtYmRhW107XG59XG5leHBvcnQgaW50ZXJmYWNlIEtpbmVzaXNBbmFseXRpY3NBcHBsaWNhdGlvbklucHV0c1NjaGVtYVJlY29yZENvbHVtbnMge1xuICByZWFkb25seSBtYXBwaW5nPzogc3RyaW5nO1xuICByZWFkb25seSBuYW1lOiBzdHJpbmc7XG4gIHJlYWRvbmx5IHNxbFR5cGU6IHN0cmluZztcbn1cbmV4cG9ydCBpbnRlcmZhY2UgS2luZXNpc0FuYWx5dGljc0FwcGxpY2F0aW9uSW5wdXRzU2NoZW1hUmVjb3JkRm9ybWF0TWFwcGluZ1BhcmFtZXRlcnNDc3Yge1xuICByZWFkb25seSByZWNvcmRDb2x1bW5EZWxpbWl0ZXI6IHN0cmluZztcbiAgcmVhZG9ubHkgcmVjb3JkUm93RGVsaW1pdGVyOiBzdHJpbmc7XG59XG5leHBvcnQgaW50ZXJmYWNlIEtpbmVzaXNBbmFseXRpY3NBcHBsaWNhdGlvbklucHV0c1NjaGVtYVJlY29yZEZvcm1hdE1hcHBpbmdQYXJhbWV0ZXJzSnNvbiB7XG4gIHJlYWRvbmx5IHJlY29yZFJvd1BhdGg6IHN0cmluZztcbn1cbmV4cG9ydCBpbnRlcmZhY2UgS2luZXNpc0FuYWx5dGljc0FwcGxpY2F0aW9uSW5wdXRzU2NoZW1hUmVjb3JkRm9ybWF0TWFwcGluZ1BhcmFtZXRlcnMge1xuICAvKiogY3N2IGJsb2NrICovXG4gIHJlYWRvbmx5IGNzdj86IEtpbmVzaXNBbmFseXRpY3NBcHBsaWNhdGlvbklucHV0c1NjaGVtYVJlY29yZEZvcm1hdE1hcHBpbmdQYXJhbWV0ZXJzQ3N2W107XG4gIC8qKiBqc29uIGJsb2NrICovXG4gIHJlYWRvbmx5IGpzb24/OiBLaW5lc2lzQW5hbHl0aWNzQXBwbGljYXRpb25JbnB1dHNTY2hlbWFSZWNvcmRGb3JtYXRNYXBwaW5nUGFyYW1ldGVyc0pzb25bXTtcbn1cbmV4cG9ydCBpbnRlcmZhY2UgS2luZXNpc0FuYWx5dGljc0FwcGxpY2F0aW9uSW5wdXRzU2NoZW1hUmVjb3JkRm9ybWF0IHtcbiAgLyoqIG1hcHBpbmdfcGFyYW1ldGVycyBibG9jayAqL1xuICByZWFkb25seSBtYXBwaW5nUGFyYW1ldGVycz86IEtpbmVzaXNBbmFseXRpY3NBcHBsaWNhdGlvbklucHV0c1NjaGVtYVJlY29yZEZvcm1hdE1hcHBpbmdQYXJhbWV0ZXJzW107XG59XG5leHBvcnQgaW50ZXJmYWNlIEtpbmVzaXNBbmFseXRpY3NBcHBsaWNhdGlvbklucHV0c1NjaGVtYSB7XG4gIHJlYWRvbmx5IHJlY29yZEVuY29kaW5nPzogc3RyaW5nO1xuICAvKiogcmVjb3JkX2NvbHVtbnMgYmxvY2sgKi9cbiAgcmVhZG9ubHkgcmVjb3JkQ29sdW1uczogS2luZXNpc0FuYWx5dGljc0FwcGxpY2F0aW9uSW5wdXRzU2NoZW1hUmVjb3JkQ29sdW1uc1tdO1xuICAvKiogcmVjb3JkX2Zvcm1hdCBibG9jayAqL1xuICByZWFkb25seSByZWNvcmRGb3JtYXQ6IEtpbmVzaXNBbmFseXRpY3NBcHBsaWNhdGlvbklucHV0c1NjaGVtYVJlY29yZEZvcm1hdFtdO1xufVxuZXhwb3J0IGludGVyZmFjZSBLaW5lc2lzQW5hbHl0aWNzQXBwbGljYXRpb25JbnB1dHMge1xuICByZWFkb25seSBuYW1lUHJlZml4OiBzdHJpbmc7XG4gIC8qKiBraW5lc2lzX2ZpcmVob3NlIGJsb2NrICovXG4gIHJlYWRvbmx5IGtpbmVzaXNGaXJlaG9zZT86IEtpbmVzaXNBbmFseXRpY3NBcHBsaWNhdGlvbklucHV0c0tpbmVzaXNGaXJlaG9zZVtdO1xuICAvKioga2luZXNpc19zdHJlYW0gYmxvY2sgKi9cbiAgcmVhZG9ubHkga2luZXNpc1N0cmVhbT86IEtpbmVzaXNBbmFseXRpY3NBcHBsaWNhdGlvbklucHV0c0tpbmVzaXNTdHJlYW1bXTtcbiAgLyoqIHBhcmFsbGVsaXNtIGJsb2NrICovXG4gIHJlYWRvbmx5IHBhcmFsbGVsaXNtPzogS2luZXNpc0FuYWx5dGljc0FwcGxpY2F0aW9uSW5wdXRzUGFyYWxsZWxpc21bXTtcbiAgLyoqIHByb2Nlc3NpbmdfY29uZmlndXJhdGlvbiBibG9jayAqL1xuICByZWFkb25seSBwcm9jZXNzaW5nQ29uZmlndXJhdGlvbj86IEtpbmVzaXNBbmFseXRpY3NBcHBsaWNhdGlvbklucHV0c1Byb2Nlc3NpbmdDb25maWd1cmF0aW9uW107XG4gIC8qKiBzY2hlbWEgYmxvY2sgKi9cbiAgcmVhZG9ubHkgc2NoZW1hOiBLaW5lc2lzQW5hbHl0aWNzQXBwbGljYXRpb25JbnB1dHNTY2hlbWFbXTtcbn1cbmV4cG9ydCBpbnRlcmZhY2UgS2luZXNpc0FuYWx5dGljc0FwcGxpY2F0aW9uT3V0cHV0c0tpbmVzaXNGaXJlaG9zZSB7XG4gIHJlYWRvbmx5IHJlc291cmNlQXJuOiBzdHJpbmc7XG4gIHJlYWRvbmx5IHJvbGVBcm46IHN0cmluZztcbn1cbmV4cG9ydCBpbnRlcmZhY2UgS2luZXNpc0FuYWx5dGljc0FwcGxpY2F0aW9uT3V0cHV0c0tpbmVzaXNTdHJlYW0ge1xuICByZWFkb25seSByZXNvdXJjZUFybjogc3RyaW5nO1xuICByZWFkb25seSByb2xlQXJuOiBzdHJpbmc7XG59XG5leHBvcnQgaW50ZXJmYWNlIEtpbmVzaXNBbmFseXRpY3NBcHBsaWNhdGlvbk91dHB1dHNMYW1iZGEge1xuICByZWFkb25seSByZXNvdXJjZUFybjogc3RyaW5nO1xuICByZWFkb25seSByb2xlQXJuOiBzdHJpbmc7XG59XG5leHBvcnQgaW50ZXJmYWNlIEtpbmVzaXNBbmFseXRpY3NBcHBsaWNhdGlvbk91dHB1dHNTY2hlbWEge1xuICByZWFkb25seSByZWNvcmRGb3JtYXRUeXBlPzogc3RyaW5nO1xufVxuZXhwb3J0IGludGVyZmFjZSBLaW5lc2lzQW5hbHl0aWNzQXBwbGljYXRpb25PdXRwdXRzIHtcbiAgcmVhZG9ubHkgbmFtZTogc3RyaW5nO1xuICAvKioga2luZXNpc19maXJlaG9zZSBibG9jayAqL1xuICByZWFkb25seSBraW5lc2lzRmlyZWhvc2U/OiBLaW5lc2lzQW5hbHl0aWNzQXBwbGljYXRpb25PdXRwdXRzS2luZXNpc0ZpcmVob3NlW107XG4gIC8qKiBraW5lc2lzX3N0cmVhbSBibG9jayAqL1xuICByZWFkb25seSBraW5lc2lzU3RyZWFtPzogS2luZXNpc0FuYWx5dGljc0FwcGxpY2F0aW9uT3V0cHV0c0tpbmVzaXNTdHJlYW1bXTtcbiAgLyoqIGxhbWJkYSBibG9jayAqL1xuICByZWFkb25seSBsYW1iZGE/OiBLaW5lc2lzQW5hbHl0aWNzQXBwbGljYXRpb25PdXRwdXRzTGFtYmRhW107XG4gIC8qKiBzY2hlbWEgYmxvY2sgKi9cbiAgcmVhZG9ubHkgc2NoZW1hOiBLaW5lc2lzQW5hbHl0aWNzQXBwbGljYXRpb25PdXRwdXRzU2NoZW1hW107XG59XG5leHBvcnQgaW50ZXJmYWNlIEtpbmVzaXNBbmFseXRpY3NBcHBsaWNhdGlvblJlZmVyZW5jZURhdGFTb3VyY2VzUzMge1xuICByZWFkb25seSBidWNrZXRBcm46IHN0cmluZztcbiAgcmVhZG9ubHkgZmlsZUtleTogc3RyaW5nO1xuICByZWFkb25seSByb2xlQXJuOiBzdHJpbmc7XG59XG5leHBvcnQgaW50ZXJmYWNlIEtpbmVzaXNBbmFseXRpY3NBcHBsaWNhdGlvblJlZmVyZW5jZURhdGFTb3VyY2VzU2NoZW1hUmVjb3JkQ29sdW1ucyB7XG4gIHJlYWRvbmx5IG1hcHBpbmc/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IG5hbWU6IHN0cmluZztcbiAgcmVhZG9ubHkgc3FsVHlwZTogc3RyaW5nO1xufVxuZXhwb3J0IGludGVyZmFjZSBLaW5lc2lzQW5hbHl0aWNzQXBwbGljYXRpb25SZWZlcmVuY2VEYXRhU291cmNlc1NjaGVtYVJlY29yZEZvcm1hdE1hcHBpbmdQYXJhbWV0ZXJzQ3N2IHtcbiAgcmVhZG9ubHkgcmVjb3JkQ29sdW1uRGVsaW1pdGVyOiBzdHJpbmc7XG4gIHJlYWRvbmx5IHJlY29yZFJvd0RlbGltaXRlcjogc3RyaW5nO1xufVxuZXhwb3J0IGludGVyZmFjZSBLaW5lc2lzQW5hbHl0aWNzQXBwbGljYXRpb25SZWZlcmVuY2VEYXRhU291cmNlc1NjaGVtYVJlY29yZEZvcm1hdE1hcHBpbmdQYXJhbWV0ZXJzSnNvbiB7XG4gIHJlYWRvbmx5IHJlY29yZFJvd1BhdGg6IHN0cmluZztcbn1cbmV4cG9ydCBpbnRlcmZhY2UgS2luZXNpc0FuYWx5dGljc0FwcGxpY2F0aW9uUmVmZXJlbmNlRGF0YVNvdXJjZXNTY2hlbWFSZWNvcmRGb3JtYXRNYXBwaW5nUGFyYW1ldGVycyB7XG4gIC8qKiBjc3YgYmxvY2sgKi9cbiAgcmVhZG9ubHkgY3N2PzogS2luZXNpc0FuYWx5dGljc0FwcGxpY2F0aW9uUmVmZXJlbmNlRGF0YVNvdXJjZXNTY2hlbWFSZWNvcmRGb3JtYXRNYXBwaW5nUGFyYW1ldGVyc0NzdltdO1xuICAvKioganNvbiBibG9jayAqL1xuICByZWFkb25seSBqc29uPzogS2luZXNpc0FuYWx5dGljc0FwcGxpY2F0aW9uUmVmZXJlbmNlRGF0YVNvdXJjZXNTY2hlbWFSZWNvcmRGb3JtYXRNYXBwaW5nUGFyYW1ldGVyc0pzb25bXTtcbn1cbmV4cG9ydCBpbnRlcmZhY2UgS2luZXNpc0FuYWx5dGljc0FwcGxpY2F0aW9uUmVmZXJlbmNlRGF0YVNvdXJjZXNTY2hlbWFSZWNvcmRGb3JtYXQge1xuICAvKiogbWFwcGluZ19wYXJhbWV0ZXJzIGJsb2NrICovXG4gIHJlYWRvbmx5IG1hcHBpbmdQYXJhbWV0ZXJzPzogS2luZXNpc0FuYWx5dGljc0FwcGxpY2F0aW9uUmVmZXJlbmNlRGF0YVNvdXJjZXNTY2hlbWFSZWNvcmRGb3JtYXRNYXBwaW5nUGFyYW1ldGVyc1tdO1xufVxuZXhwb3J0IGludGVyZmFjZSBLaW5lc2lzQW5hbHl0aWNzQXBwbGljYXRpb25SZWZlcmVuY2VEYXRhU291cmNlc1NjaGVtYSB7XG4gIHJlYWRvbmx5IHJlY29yZEVuY29kaW5nPzogc3RyaW5nO1xuICAvKiogcmVjb3JkX2NvbHVtbnMgYmxvY2sgKi9cbiAgcmVhZG9ubHkgcmVjb3JkQ29sdW1uczogS2luZXNpc0FuYWx5dGljc0FwcGxpY2F0aW9uUmVmZXJlbmNlRGF0YVNvdXJjZXNTY2hlbWFSZWNvcmRDb2x1bW5zW107XG4gIC8qKiByZWNvcmRfZm9ybWF0IGJsb2NrICovXG4gIHJlYWRvbmx5IHJlY29yZEZvcm1hdDogS2luZXNpc0FuYWx5dGljc0FwcGxpY2F0aW9uUmVmZXJlbmNlRGF0YVNvdXJjZXNTY2hlbWFSZWNvcmRGb3JtYXRbXTtcbn1cbmV4cG9ydCBpbnRlcmZhY2UgS2luZXNpc0FuYWx5dGljc0FwcGxpY2F0aW9uUmVmZXJlbmNlRGF0YVNvdXJjZXMge1xuICByZWFkb25seSB0YWJsZU5hbWU6IHN0cmluZztcbiAgLyoqIHMzIGJsb2NrICovXG4gIHJlYWRvbmx5IHMzOiBLaW5lc2lzQW5hbHl0aWNzQXBwbGljYXRpb25SZWZlcmVuY2VEYXRhU291cmNlc1MzW107XG4gIC8qKiBzY2hlbWEgYmxvY2sgKi9cbiAgcmVhZG9ubHkgc2NoZW1hOiBLaW5lc2lzQW5hbHl0aWNzQXBwbGljYXRpb25SZWZlcmVuY2VEYXRhU291cmNlc1NjaGVtYVtdO1xufVxuXG4vLyBSZXNvdXJjZVxuXG5leHBvcnQgY2xhc3MgS2luZXNpc0FuYWx5dGljc0FwcGxpY2F0aW9uIGV4dGVuZHMgVGVycmFmb3JtUmVzb3VyY2Uge1xuXG4gIC8vID09PT09PT09PT09XG4gIC8vIElOSVRJQUxJWkVSXG4gIC8vID09PT09PT09PT09XG5cbiAgcHVibGljIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIGNvbmZpZzogS2luZXNpc0FuYWx5dGljc0FwcGxpY2F0aW9uQ29uZmlnKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCB7XG4gICAgICB0ZXJyYWZvcm1SZXNvdXJjZVR5cGU6ICdhd3Nfa2luZXNpc19hbmFseXRpY3NfYXBwbGljYXRpb24nLFxuICAgICAgdGVycmFmb3JtR2VuZXJhdG9yTWV0YWRhdGE6IHtcbiAgICAgICAgcHJvdmlkZXJOYW1lOiAnYXdzJ1xuICAgICAgfSxcbiAgICAgIHByb3ZpZGVyOiBjb25maWcucHJvdmlkZXIsXG4gICAgICBkZXBlbmRzT246IGNvbmZpZy5kZXBlbmRzT24sXG4gICAgICBjb3VudDogY29uZmlnLmNvdW50LFxuICAgICAgbGlmZWN5Y2xlOiBjb25maWcubGlmZWN5Y2xlXG4gICAgfSk7XG4gICAgdGhpcy5fY29kZSA9IGNvbmZpZy5jb2RlO1xuICAgIHRoaXMuX2Rlc2NyaXB0aW9uID0gY29uZmlnLmRlc2NyaXB0aW9uO1xuICAgIHRoaXMuX25hbWUgPSBjb25maWcubmFtZTtcbiAgICB0aGlzLl90YWdzID0gY29uZmlnLnRhZ3M7XG4gICAgdGhpcy5fY2xvdWR3YXRjaExvZ2dpbmdPcHRpb25zID0gY29uZmlnLmNsb3Vkd2F0Y2hMb2dnaW5nT3B0aW9ucztcbiAgICB0aGlzLl9pbnB1dHMgPSBjb25maWcuaW5wdXRzO1xuICAgIHRoaXMuX291dHB1dHMgPSBjb25maWcub3V0cHV0cztcbiAgICB0aGlzLl9yZWZlcmVuY2VEYXRhU291cmNlcyA9IGNvbmZpZy5yZWZlcmVuY2VEYXRhU291cmNlcztcbiAgfVxuXG4gIC8vID09PT09PT09PT1cbiAgLy8gQVRUUklCVVRFU1xuICAvLyA9PT09PT09PT09XG5cbiAgLy8gYXJuIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IHRydWVcbiAgcHVibGljIGdldCBhcm4oKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdhcm4nKTtcbiAgfVxuXG4gIC8vIGNvZGUgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfY29kZT86IHN0cmluZztcbiAgcHVibGljIGdldCBjb2RlKCkge1xuICAgIHJldHVybiB0aGlzLl9jb2RlO1xuICB9XG4gIHB1YmxpYyBzZXQgY29kZSh2YWx1ZTogc3RyaW5nIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fY29kZSA9IHZhbHVlO1xuICB9XG5cbiAgLy8gY3JlYXRlX3RpbWVzdGFtcCAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiB0cnVlXG4gIHB1YmxpYyBnZXQgY3JlYXRlVGltZXN0YW1wKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnY3JlYXRlX3RpbWVzdGFtcCcpO1xuICB9XG5cbiAgLy8gZGVzY3JpcHRpb24gLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfZGVzY3JpcHRpb24/OiBzdHJpbmc7XG4gIHB1YmxpYyBnZXQgZGVzY3JpcHRpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMuX2Rlc2NyaXB0aW9uO1xuICB9XG4gIHB1YmxpYyBzZXQgZGVzY3JpcHRpb24odmFsdWU6IHN0cmluZyB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX2Rlc2NyaXB0aW9uID0gdmFsdWU7XG4gIH1cblxuICAvLyBpZCAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2lkPzogc3RyaW5nO1xuICBwdWJsaWMgZ2V0IGlkKCkge1xuICAgIHJldHVybiB0aGlzLl9pZCA/PyB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnaWQnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGlkKHZhbHVlOiBzdHJpbmcgfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9pZCA9IHZhbHVlO1xuICB9XG5cbiAgLy8gbGFzdF91cGRhdGVfdGltZXN0YW1wIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IHRydWVcbiAgcHVibGljIGdldCBsYXN0VXBkYXRlVGltZXN0YW1wKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnbGFzdF91cGRhdGVfdGltZXN0YW1wJyk7XG4gIH1cblxuICAvLyBuYW1lIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiB0cnVlXG4gIHByaXZhdGUgX25hbWU6IHN0cmluZztcbiAgcHVibGljIGdldCBuYW1lKCkge1xuICAgIHJldHVybiB0aGlzLl9uYW1lO1xuICB9XG4gIHB1YmxpYyBzZXQgbmFtZSh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fbmFtZSA9IHZhbHVlO1xuICB9XG5cbiAgLy8gc3RhdHVzIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IHRydWVcbiAgcHVibGljIGdldCBzdGF0dXMoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdzdGF0dXMnKTtcbiAgfVxuXG4gIC8vIHRhZ3MgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfdGFncz86IHsgW2tleTogc3RyaW5nXTogc3RyaW5nIH07XG4gIHB1YmxpYyBnZXQgdGFncygpIHtcbiAgICByZXR1cm4gdGhpcy5fdGFncztcbiAgfVxuICBwdWJsaWMgc2V0IHRhZ3ModmFsdWU6IHsgW2tleTogc3RyaW5nXTogc3RyaW5nIH0gfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl90YWdzID0gdmFsdWU7XG4gIH1cblxuICAvLyB2ZXJzaW9uIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IHRydWVcbiAgcHVibGljIGdldCB2ZXJzaW9uKCkge1xuICAgIHJldHVybiB0aGlzLmdldE51bWJlckF0dHJpYnV0ZSgndmVyc2lvbicpO1xuICB9XG5cbiAgLy8gY2xvdWR3YXRjaF9sb2dnaW5nX29wdGlvbnMgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfY2xvdWR3YXRjaExvZ2dpbmdPcHRpb25zPzogS2luZXNpc0FuYWx5dGljc0FwcGxpY2F0aW9uQ2xvdWR3YXRjaExvZ2dpbmdPcHRpb25zW107XG4gIHB1YmxpYyBnZXQgY2xvdWR3YXRjaExvZ2dpbmdPcHRpb25zKCkge1xuICAgIHJldHVybiB0aGlzLl9jbG91ZHdhdGNoTG9nZ2luZ09wdGlvbnM7XG4gIH1cbiAgcHVibGljIHNldCBjbG91ZHdhdGNoTG9nZ2luZ09wdGlvbnModmFsdWU6IEtpbmVzaXNBbmFseXRpY3NBcHBsaWNhdGlvbkNsb3Vkd2F0Y2hMb2dnaW5nT3B0aW9uc1tdIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fY2xvdWR3YXRjaExvZ2dpbmdPcHRpb25zID0gdmFsdWU7XG4gIH1cblxuICAvLyBpbnB1dHMgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfaW5wdXRzPzogS2luZXNpc0FuYWx5dGljc0FwcGxpY2F0aW9uSW5wdXRzW107XG4gIHB1YmxpYyBnZXQgaW5wdXRzKCkge1xuICAgIHJldHVybiB0aGlzLl9pbnB1dHM7XG4gIH1cbiAgcHVibGljIHNldCBpbnB1dHModmFsdWU6IEtpbmVzaXNBbmFseXRpY3NBcHBsaWNhdGlvbklucHV0c1tdIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5faW5wdXRzID0gdmFsdWU7XG4gIH1cblxuICAvLyBvdXRwdXRzIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX291dHB1dHM/OiBLaW5lc2lzQW5hbHl0aWNzQXBwbGljYXRpb25PdXRwdXRzW107XG4gIHB1YmxpYyBnZXQgb3V0cHV0cygpIHtcbiAgICByZXR1cm4gdGhpcy5fb3V0cHV0cztcbiAgfVxuICBwdWJsaWMgc2V0IG91dHB1dHModmFsdWU6IEtpbmVzaXNBbmFseXRpY3NBcHBsaWNhdGlvbk91dHB1dHNbXSB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX291dHB1dHMgPSB2YWx1ZTtcbiAgfVxuXG4gIC8vIHJlZmVyZW5jZV9kYXRhX3NvdXJjZXMgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfcmVmZXJlbmNlRGF0YVNvdXJjZXM/OiBLaW5lc2lzQW5hbHl0aWNzQXBwbGljYXRpb25SZWZlcmVuY2VEYXRhU291cmNlc1tdO1xuICBwdWJsaWMgZ2V0IHJlZmVyZW5jZURhdGFTb3VyY2VzKCkge1xuICAgIHJldHVybiB0aGlzLl9yZWZlcmVuY2VEYXRhU291cmNlcztcbiAgfVxuICBwdWJsaWMgc2V0IHJlZmVyZW5jZURhdGFTb3VyY2VzKHZhbHVlOiBLaW5lc2lzQW5hbHl0aWNzQXBwbGljYXRpb25SZWZlcmVuY2VEYXRhU291cmNlc1tdIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fcmVmZXJlbmNlRGF0YVNvdXJjZXMgPSB2YWx1ZTtcbiAgfVxuXG4gIC8vID09PT09PT09PVxuICAvLyBTWU5USEVTSVNcbiAgLy8gPT09PT09PT09XG5cbiAgcHVibGljIHN5bnRoZXNpemVBdHRyaWJ1dGVzKCk6IHsgW25hbWU6IHN0cmluZ106IGFueSB9IHtcbiAgICByZXR1cm4ge1xuICAgICAgY29kZTogdGhpcy5fY29kZSxcbiAgICAgIGRlc2NyaXB0aW9uOiB0aGlzLl9kZXNjcmlwdGlvbixcbiAgICAgIG5hbWU6IHRoaXMuX25hbWUsXG4gICAgICB0YWdzOiB0aGlzLl90YWdzLFxuICAgICAgY2xvdWR3YXRjaF9sb2dnaW5nX29wdGlvbnM6IHRoaXMuX2Nsb3Vkd2F0Y2hMb2dnaW5nT3B0aW9ucyxcbiAgICAgIGlucHV0czogdGhpcy5faW5wdXRzLFxuICAgICAgb3V0cHV0czogdGhpcy5fb3V0cHV0cyxcbiAgICAgIHJlZmVyZW5jZV9kYXRhX3NvdXJjZXM6IHRoaXMuX3JlZmVyZW5jZURhdGFTb3VyY2VzLFxuICAgIH07XG4gIH1cbn1cbiJdfQ==