import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface KinesisFirehoseDeliveryStreamConfig extends TerraformMetaArguments {
    readonly destination: string;
    readonly destinationId?: string;
    readonly name: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly versionId?: string;
    /** elasticsearch_configuration block */
    readonly elasticsearchConfiguration?: KinesisFirehoseDeliveryStreamElasticsearchConfiguration[];
    /** extended_s3_configuration block */
    readonly extendedS3Configuration?: KinesisFirehoseDeliveryStreamExtendedS3Configuration[];
    /** kinesis_source_configuration block */
    readonly kinesisSourceConfiguration?: KinesisFirehoseDeliveryStreamKinesisSourceConfiguration[];
    /** redshift_configuration block */
    readonly redshiftConfiguration?: KinesisFirehoseDeliveryStreamRedshiftConfiguration[];
    /** s3_configuration block */
    readonly s3Configuration?: KinesisFirehoseDeliveryStreamS3Configuration[];
    /** server_side_encryption block */
    readonly serverSideEncryption?: KinesisFirehoseDeliveryStreamServerSideEncryption[];
    /** splunk_configuration block */
    readonly splunkConfiguration?: KinesisFirehoseDeliveryStreamSplunkConfiguration[];
}
export interface KinesisFirehoseDeliveryStreamElasticsearchConfigurationCloudwatchLoggingOptions {
    readonly enabled?: boolean;
    readonly logGroupName?: string;
    readonly logStreamName?: string;
}
export interface KinesisFirehoseDeliveryStreamElasticsearchConfigurationProcessingConfigurationProcessorsParameters {
    readonly parameterName: string;
    readonly parameterValue: string;
}
export interface KinesisFirehoseDeliveryStreamElasticsearchConfigurationProcessingConfigurationProcessors {
    readonly type: string;
    /** parameters block */
    readonly parameters?: KinesisFirehoseDeliveryStreamElasticsearchConfigurationProcessingConfigurationProcessorsParameters[];
}
export interface KinesisFirehoseDeliveryStreamElasticsearchConfigurationProcessingConfiguration {
    readonly enabled?: boolean;
    /** processors block */
    readonly processors?: KinesisFirehoseDeliveryStreamElasticsearchConfigurationProcessingConfigurationProcessors[];
}
export interface KinesisFirehoseDeliveryStreamElasticsearchConfiguration {
    readonly bufferingInterval?: number;
    readonly bufferingSize?: number;
    readonly domainArn: string;
    readonly indexName: string;
    readonly indexRotationPeriod?: string;
    readonly retryDuration?: number;
    readonly roleArn: string;
    readonly s3BackupMode?: string;
    readonly typeName?: string;
    /** cloudwatch_logging_options block */
    readonly cloudwatchLoggingOptions?: KinesisFirehoseDeliveryStreamElasticsearchConfigurationCloudwatchLoggingOptions[];
    /** processing_configuration block */
    readonly processingConfiguration?: KinesisFirehoseDeliveryStreamElasticsearchConfigurationProcessingConfiguration[];
}
export interface KinesisFirehoseDeliveryStreamExtendedS3ConfigurationCloudwatchLoggingOptions {
    readonly enabled?: boolean;
    readonly logGroupName?: string;
    readonly logStreamName?: string;
}
export interface KinesisFirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationInputFormatConfigurationDeserializerHiveJsonSerDe {
    readonly timestampFormats?: string[];
}
export interface KinesisFirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationInputFormatConfigurationDeserializerOpenXJsonSerDe {
    readonly caseInsensitive?: boolean;
    readonly columnToJsonKeyMappings?: {
        [key: string]: string;
    };
    readonly convertDotsInJsonKeysToUnderscores?: boolean;
}
export interface KinesisFirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationInputFormatConfigurationDeserializer {
    /** hive_json_ser_de block */
    readonly hiveJsonSerDe?: KinesisFirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationInputFormatConfigurationDeserializerHiveJsonSerDe[];
    /** open_x_json_ser_de block */
    readonly openXJsonSerDe?: KinesisFirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationInputFormatConfigurationDeserializerOpenXJsonSerDe[];
}
export interface KinesisFirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationInputFormatConfiguration {
    /** deserializer block */
    readonly deserializer: KinesisFirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationInputFormatConfigurationDeserializer[];
}
export interface KinesisFirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationOutputFormatConfigurationSerializerOrcSerDe {
    readonly blockSizeBytes?: number;
    readonly bloomFilterColumns?: string[];
    readonly bloomFilterFalsePositiveProbability?: number;
    readonly compression?: string;
    readonly dictionaryKeyThreshold?: number;
    readonly enablePadding?: boolean;
    readonly formatVersion?: string;
    readonly paddingTolerance?: number;
    readonly rowIndexStride?: number;
    readonly stripeSizeBytes?: number;
}
export interface KinesisFirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationOutputFormatConfigurationSerializerParquetSerDe {
    readonly blockSizeBytes?: number;
    readonly compression?: string;
    readonly enableDictionaryCompression?: boolean;
    readonly maxPaddingBytes?: number;
    readonly pageSizeBytes?: number;
    readonly writerVersion?: string;
}
export interface KinesisFirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationOutputFormatConfigurationSerializer {
    /** orc_ser_de block */
    readonly orcSerDe?: KinesisFirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationOutputFormatConfigurationSerializerOrcSerDe[];
    /** parquet_ser_de block */
    readonly parquetSerDe?: KinesisFirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationOutputFormatConfigurationSerializerParquetSerDe[];
}
export interface KinesisFirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationOutputFormatConfiguration {
    /** serializer block */
    readonly serializer: KinesisFirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationOutputFormatConfigurationSerializer[];
}
export interface KinesisFirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationSchemaConfiguration {
    readonly catalogId?: string;
    readonly databaseName: string;
    readonly region?: string;
    readonly roleArn: string;
    readonly tableName: string;
    readonly versionId?: string;
}
export interface KinesisFirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfiguration {
    readonly enabled?: boolean;
    /** input_format_configuration block */
    readonly inputFormatConfiguration: KinesisFirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationInputFormatConfiguration[];
    /** output_format_configuration block */
    readonly outputFormatConfiguration: KinesisFirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationOutputFormatConfiguration[];
    /** schema_configuration block */
    readonly schemaConfiguration: KinesisFirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationSchemaConfiguration[];
}
export interface KinesisFirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorsParameters {
    readonly parameterName: string;
    readonly parameterValue: string;
}
export interface KinesisFirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessors {
    readonly type: string;
    /** parameters block */
    readonly parameters?: KinesisFirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorsParameters[];
}
export interface KinesisFirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfiguration {
    readonly enabled?: boolean;
    /** processors block */
    readonly processors?: KinesisFirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessors[];
}
export interface KinesisFirehoseDeliveryStreamExtendedS3ConfigurationS3BackupConfigurationCloudwatchLoggingOptions {
    readonly enabled?: boolean;
    readonly logGroupName?: string;
    readonly logStreamName?: string;
}
export interface KinesisFirehoseDeliveryStreamExtendedS3ConfigurationS3BackupConfiguration {
    readonly bucketArn: string;
    readonly bufferInterval?: number;
    readonly bufferSize?: number;
    readonly compressionFormat?: string;
    readonly kmsKeyArn?: string;
    readonly prefix?: string;
    readonly roleArn: string;
    /** cloudwatch_logging_options block */
    readonly cloudwatchLoggingOptions?: KinesisFirehoseDeliveryStreamExtendedS3ConfigurationS3BackupConfigurationCloudwatchLoggingOptions[];
}
export interface KinesisFirehoseDeliveryStreamExtendedS3Configuration {
    readonly bucketArn: string;
    readonly bufferInterval?: number;
    readonly bufferSize?: number;
    readonly compressionFormat?: string;
    readonly errorOutputPrefix?: string;
    readonly kmsKeyArn?: string;
    readonly prefix?: string;
    readonly roleArn: string;
    readonly s3BackupMode?: string;
    /** cloudwatch_logging_options block */
    readonly cloudwatchLoggingOptions?: KinesisFirehoseDeliveryStreamExtendedS3ConfigurationCloudwatchLoggingOptions[];
    /** data_format_conversion_configuration block */
    readonly dataFormatConversionConfiguration?: KinesisFirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfiguration[];
    /** processing_configuration block */
    readonly processingConfiguration?: KinesisFirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfiguration[];
    /** s3_backup_configuration block */
    readonly s3BackupConfiguration?: KinesisFirehoseDeliveryStreamExtendedS3ConfigurationS3BackupConfiguration[];
}
export interface KinesisFirehoseDeliveryStreamKinesisSourceConfiguration {
    readonly kinesisStreamArn: string;
    readonly roleArn: string;
}
export interface KinesisFirehoseDeliveryStreamRedshiftConfigurationCloudwatchLoggingOptions {
    readonly enabled?: boolean;
    readonly logGroupName?: string;
    readonly logStreamName?: string;
}
export interface KinesisFirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationProcessorsParameters {
    readonly parameterName: string;
    readonly parameterValue: string;
}
export interface KinesisFirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationProcessors {
    readonly type: string;
    /** parameters block */
    readonly parameters?: KinesisFirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationProcessorsParameters[];
}
export interface KinesisFirehoseDeliveryStreamRedshiftConfigurationProcessingConfiguration {
    readonly enabled?: boolean;
    /** processors block */
    readonly processors?: KinesisFirehoseDeliveryStreamRedshiftConfigurationProcessingConfigurationProcessors[];
}
export interface KinesisFirehoseDeliveryStreamRedshiftConfigurationS3BackupConfigurationCloudwatchLoggingOptions {
    readonly enabled?: boolean;
    readonly logGroupName?: string;
    readonly logStreamName?: string;
}
export interface KinesisFirehoseDeliveryStreamRedshiftConfigurationS3BackupConfiguration {
    readonly bucketArn: string;
    readonly bufferInterval?: number;
    readonly bufferSize?: number;
    readonly compressionFormat?: string;
    readonly kmsKeyArn?: string;
    readonly prefix?: string;
    readonly roleArn: string;
    /** cloudwatch_logging_options block */
    readonly cloudwatchLoggingOptions?: KinesisFirehoseDeliveryStreamRedshiftConfigurationS3BackupConfigurationCloudwatchLoggingOptions[];
}
export interface KinesisFirehoseDeliveryStreamRedshiftConfiguration {
    readonly clusterJdbcurl: string;
    readonly copyOptions?: string;
    readonly dataTableColumns?: string;
    readonly dataTableName: string;
    readonly password: string;
    readonly retryDuration?: number;
    readonly roleArn: string;
    readonly s3BackupMode?: string;
    readonly username: string;
    /** cloudwatch_logging_options block */
    readonly cloudwatchLoggingOptions?: KinesisFirehoseDeliveryStreamRedshiftConfigurationCloudwatchLoggingOptions[];
    /** processing_configuration block */
    readonly processingConfiguration?: KinesisFirehoseDeliveryStreamRedshiftConfigurationProcessingConfiguration[];
    /** s3_backup_configuration block */
    readonly s3BackupConfiguration?: KinesisFirehoseDeliveryStreamRedshiftConfigurationS3BackupConfiguration[];
}
export interface KinesisFirehoseDeliveryStreamS3ConfigurationCloudwatchLoggingOptions {
    readonly enabled?: boolean;
    readonly logGroupName?: string;
    readonly logStreamName?: string;
}
export interface KinesisFirehoseDeliveryStreamS3Configuration {
    readonly bucketArn: string;
    readonly bufferInterval?: number;
    readonly bufferSize?: number;
    readonly compressionFormat?: string;
    readonly kmsKeyArn?: string;
    readonly prefix?: string;
    readonly roleArn: string;
    /** cloudwatch_logging_options block */
    readonly cloudwatchLoggingOptions?: KinesisFirehoseDeliveryStreamS3ConfigurationCloudwatchLoggingOptions[];
}
export interface KinesisFirehoseDeliveryStreamServerSideEncryption {
    readonly enabled?: boolean;
}
export interface KinesisFirehoseDeliveryStreamSplunkConfigurationCloudwatchLoggingOptions {
    readonly enabled?: boolean;
    readonly logGroupName?: string;
    readonly logStreamName?: string;
}
export interface KinesisFirehoseDeliveryStreamSplunkConfigurationProcessingConfigurationProcessorsParameters {
    readonly parameterName: string;
    readonly parameterValue: string;
}
export interface KinesisFirehoseDeliveryStreamSplunkConfigurationProcessingConfigurationProcessors {
    readonly type: string;
    /** parameters block */
    readonly parameters?: KinesisFirehoseDeliveryStreamSplunkConfigurationProcessingConfigurationProcessorsParameters[];
}
export interface KinesisFirehoseDeliveryStreamSplunkConfigurationProcessingConfiguration {
    readonly enabled?: boolean;
    /** processors block */
    readonly processors?: KinesisFirehoseDeliveryStreamSplunkConfigurationProcessingConfigurationProcessors[];
}
export interface KinesisFirehoseDeliveryStreamSplunkConfiguration {
    readonly hecAcknowledgmentTimeout?: number;
    readonly hecEndpoint: string;
    readonly hecEndpointType?: string;
    readonly hecToken: string;
    readonly retryDuration?: number;
    readonly s3BackupMode?: string;
    /** cloudwatch_logging_options block */
    readonly cloudwatchLoggingOptions?: KinesisFirehoseDeliveryStreamSplunkConfigurationCloudwatchLoggingOptions[];
    /** processing_configuration block */
    readonly processingConfiguration?: KinesisFirehoseDeliveryStreamSplunkConfigurationProcessingConfiguration[];
}
export declare class KinesisFirehoseDeliveryStream extends TerraformResource {
    constructor(scope: Construct, id: string, config: KinesisFirehoseDeliveryStreamConfig);
    private _arn?;
    get arn(): string | undefined;
    set arn(value: string | undefined);
    private _destination;
    get destination(): string;
    set destination(value: string);
    private _destinationId?;
    get destinationId(): string | undefined;
    set destinationId(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _versionId?;
    get versionId(): string | undefined;
    set versionId(value: string | undefined);
    private _elasticsearchConfiguration?;
    get elasticsearchConfiguration(): KinesisFirehoseDeliveryStreamElasticsearchConfiguration[] | undefined;
    set elasticsearchConfiguration(value: KinesisFirehoseDeliveryStreamElasticsearchConfiguration[] | undefined);
    private _extendedS3Configuration?;
    get extendedS3Configuration(): KinesisFirehoseDeliveryStreamExtendedS3Configuration[] | undefined;
    set extendedS3Configuration(value: KinesisFirehoseDeliveryStreamExtendedS3Configuration[] | undefined);
    private _kinesisSourceConfiguration?;
    get kinesisSourceConfiguration(): KinesisFirehoseDeliveryStreamKinesisSourceConfiguration[] | undefined;
    set kinesisSourceConfiguration(value: KinesisFirehoseDeliveryStreamKinesisSourceConfiguration[] | undefined);
    private _redshiftConfiguration?;
    get redshiftConfiguration(): KinesisFirehoseDeliveryStreamRedshiftConfiguration[] | undefined;
    set redshiftConfiguration(value: KinesisFirehoseDeliveryStreamRedshiftConfiguration[] | undefined);
    private _s3Configuration?;
    get s3Configuration(): KinesisFirehoseDeliveryStreamS3Configuration[] | undefined;
    set s3Configuration(value: KinesisFirehoseDeliveryStreamS3Configuration[] | undefined);
    private _serverSideEncryption?;
    get serverSideEncryption(): KinesisFirehoseDeliveryStreamServerSideEncryption[] | undefined;
    set serverSideEncryption(value: KinesisFirehoseDeliveryStreamServerSideEncryption[] | undefined);
    private _splunkConfiguration?;
    get splunkConfiguration(): KinesisFirehoseDeliveryStreamSplunkConfiguration[] | undefined;
    set splunkConfiguration(value: KinesisFirehoseDeliveryStreamSplunkConfiguration[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
