"use strict";
// https://www.terraform.io/docs/providers/aws/r/kinesis_firehose_delivery_stream.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisFirehoseDeliveryStream = void 0;
const cdktf_1 = require("cdktf");
// Resource
class KinesisFirehoseDeliveryStream extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_kinesis_firehose_delivery_stream',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._destination = config.destination;
        this._destinationId = config.destinationId;
        this._name = config.name;
        this._tags = config.tags;
        this._versionId = config.versionId;
        this._elasticsearchConfiguration = config.elasticsearchConfiguration;
        this._extendedS3Configuration = config.extendedS3Configuration;
        this._kinesisSourceConfiguration = config.kinesisSourceConfiguration;
        this._redshiftConfiguration = config.redshiftConfiguration;
        this._s3Configuration = config.s3Configuration;
        this._serverSideEncryption = config.serverSideEncryption;
        this._splunkConfiguration = config.splunkConfiguration;
    }
    get arn() {
        var _a;
        return (_a = this._arn) !== null && _a !== void 0 ? _a : this.getStringAttribute('arn');
    }
    set arn(value) {
        this._arn = value;
    }
    get destination() {
        return this._destination;
    }
    set destination(value) {
        this._destination = value;
    }
    get destinationId() {
        var _a;
        return (_a = this._destinationId) !== null && _a !== void 0 ? _a : this.getStringAttribute('destination_id');
    }
    set destinationId(value) {
        this._destinationId = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get name() {
        return this._name;
    }
    set name(value) {
        this._name = value;
    }
    get tags() {
        return this._tags;
    }
    set tags(value) {
        this._tags = value;
    }
    get versionId() {
        var _a;
        return (_a = this._versionId) !== null && _a !== void 0 ? _a : this.getStringAttribute('version_id');
    }
    set versionId(value) {
        this._versionId = value;
    }
    get elasticsearchConfiguration() {
        return this._elasticsearchConfiguration;
    }
    set elasticsearchConfiguration(value) {
        this._elasticsearchConfiguration = value;
    }
    get extendedS3Configuration() {
        return this._extendedS3Configuration;
    }
    set extendedS3Configuration(value) {
        this._extendedS3Configuration = value;
    }
    get kinesisSourceConfiguration() {
        return this._kinesisSourceConfiguration;
    }
    set kinesisSourceConfiguration(value) {
        this._kinesisSourceConfiguration = value;
    }
    get redshiftConfiguration() {
        return this._redshiftConfiguration;
    }
    set redshiftConfiguration(value) {
        this._redshiftConfiguration = value;
    }
    get s3Configuration() {
        return this._s3Configuration;
    }
    set s3Configuration(value) {
        this._s3Configuration = value;
    }
    get serverSideEncryption() {
        return this._serverSideEncryption;
    }
    set serverSideEncryption(value) {
        this._serverSideEncryption = value;
    }
    get splunkConfiguration() {
        return this._splunkConfiguration;
    }
    set splunkConfiguration(value) {
        this._splunkConfiguration = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            destination: this._destination,
            destination_id: this._destinationId,
            name: this._name,
            tags: this._tags,
            version_id: this._versionId,
            elasticsearch_configuration: this._elasticsearchConfiguration,
            extended_s3_configuration: this._extendedS3Configuration,
            kinesis_source_configuration: this._kinesisSourceConfiguration,
            redshift_configuration: this._redshiftConfiguration,
            s3_configuration: this._s3Configuration,
            server_side_encryption: this._serverSideEncryption,
            splunk_configuration: this._splunkConfiguration,
        };
    }
}
exports.KinesisFirehoseDeliveryStream = KinesisFirehoseDeliveryStream;
//# sourceMappingURL=data:application/json;base64,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