import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface KinesisStreamConfig extends TerraformMetaArguments {
    readonly encryptionType?: string;
    readonly enforceConsumerDeletion?: boolean;
    readonly kmsKeyId?: string;
    readonly name: string;
    readonly retentionPeriod?: number;
    readonly shardCount: number;
    readonly shardLevelMetrics?: string[];
    readonly tags?: {
        [key: string]: string;
    };
    /** timeouts block */
    readonly timeouts?: KinesisStreamTimeouts;
}
export interface KinesisStreamTimeouts {
    readonly create?: string;
    readonly delete?: string;
    readonly update?: string;
}
export declare class KinesisStream extends TerraformResource {
    constructor(scope: Construct, id: string, config: KinesisStreamConfig);
    private _arn?;
    get arn(): string | undefined;
    set arn(value: string | undefined);
    private _encryptionType?;
    get encryptionType(): string | undefined;
    set encryptionType(value: string | undefined);
    private _enforceConsumerDeletion?;
    get enforceConsumerDeletion(): boolean | undefined;
    set enforceConsumerDeletion(value: boolean | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _kmsKeyId?;
    get kmsKeyId(): string | undefined;
    set kmsKeyId(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _retentionPeriod?;
    get retentionPeriod(): number | undefined;
    set retentionPeriod(value: number | undefined);
    private _shardCount;
    get shardCount(): number;
    set shardCount(value: number);
    private _shardLevelMetrics?;
    get shardLevelMetrics(): string[] | undefined;
    set shardLevelMetrics(value: string[] | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _timeouts?;
    get timeouts(): KinesisStreamTimeouts | undefined;
    set timeouts(value: KinesisStreamTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
