import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface KinesisVideoStreamConfig extends TerraformMetaArguments {
    readonly dataRetentionInHours?: number;
    readonly deviceName?: string;
    readonly kmsKeyId?: string;
    readonly mediaType?: string;
    readonly name: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** timeouts block */
    readonly timeouts?: KinesisVideoStreamTimeouts;
}
export interface KinesisVideoStreamTimeouts {
    readonly create?: string;
    readonly delete?: string;
    readonly update?: string;
}
export declare class KinesisVideoStream extends TerraformResource {
    constructor(scope: Construct, id: string, config: KinesisVideoStreamConfig);
    get arn(): string;
    get creationTime(): string;
    private _dataRetentionInHours?;
    get dataRetentionInHours(): number | undefined;
    set dataRetentionInHours(value: number | undefined);
    private _deviceName?;
    get deviceName(): string | undefined;
    set deviceName(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _kmsKeyId?;
    get kmsKeyId(): string | undefined;
    set kmsKeyId(value: string | undefined);
    private _mediaType?;
    get mediaType(): string | undefined;
    set mediaType(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get version(): string;
    private _timeouts?;
    get timeouts(): KinesisVideoStreamTimeouts | undefined;
    set timeouts(value: KinesisVideoStreamTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
