import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface KmsExternalKeyConfig extends TerraformMetaArguments {
    readonly deletionWindowInDays?: number;
    readonly description?: string;
    readonly enabled?: boolean;
    readonly keyMaterialBase64?: string;
    readonly policy?: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly validTo?: string;
}
export declare class KmsExternalKey extends TerraformResource {
    constructor(scope: Construct, id: string, config?: KmsExternalKeyConfig);
    get arn(): string;
    private _deletionWindowInDays?;
    get deletionWindowInDays(): number | undefined;
    set deletionWindowInDays(value: number | undefined);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _enabled?;
    get enabled(): boolean | undefined;
    set enabled(value: boolean | undefined);
    get expirationModel(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _keyMaterialBase64?;
    get keyMaterialBase64(): string | undefined;
    set keyMaterialBase64(value: string | undefined);
    get keyState(): string;
    get keyUsage(): string;
    private _policy?;
    get policy(): string | undefined;
    set policy(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _validTo?;
    get validTo(): string | undefined;
    set validTo(value: string | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
