import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface KmsGrantConfig extends TerraformMetaArguments {
    readonly grantCreationTokens?: string[];
    readonly granteePrincipal: string;
    readonly keyId: string;
    readonly name?: string;
    readonly operations: string[];
    readonly retireOnDelete?: boolean;
    readonly retiringPrincipal?: string;
    /** constraints block */
    readonly constraints?: KmsGrantConstraints[];
}
export interface KmsGrantConstraints {
    readonly encryptionContextEquals?: {
        [key: string]: string;
    };
    readonly encryptionContextSubset?: {
        [key: string]: string;
    };
}
export declare class KmsGrant extends TerraformResource {
    constructor(scope: Construct, id: string, config: KmsGrantConfig);
    private _grantCreationTokens?;
    get grantCreationTokens(): string[] | undefined;
    set grantCreationTokens(value: string[] | undefined);
    get grantId(): string;
    get grantToken(): string;
    private _granteePrincipal;
    get granteePrincipal(): string;
    set granteePrincipal(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _keyId;
    get keyId(): string;
    set keyId(value: string);
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    private _operations;
    get operations(): string[];
    set operations(value: string[]);
    private _retireOnDelete?;
    get retireOnDelete(): boolean | undefined;
    set retireOnDelete(value: boolean | undefined);
    private _retiringPrincipal?;
    get retiringPrincipal(): string | undefined;
    set retiringPrincipal(value: string | undefined);
    private _constraints?;
    get constraints(): KmsGrantConstraints[] | undefined;
    set constraints(value: KmsGrantConstraints[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
