import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface KmsKeyConfig extends TerraformMetaArguments {
    readonly customerMasterKeySpec?: string;
    readonly deletionWindowInDays?: number;
    readonly description?: string;
    readonly enableKeyRotation?: boolean;
    readonly isEnabled?: boolean;
    readonly keyUsage?: string;
    readonly policy?: string;
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class KmsKey extends TerraformResource {
    constructor(scope: Construct, id: string, config?: KmsKeyConfig);
    get arn(): string;
    private _customerMasterKeySpec?;
    get customerMasterKeySpec(): string | undefined;
    set customerMasterKeySpec(value: string | undefined);
    private _deletionWindowInDays?;
    get deletionWindowInDays(): number | undefined;
    set deletionWindowInDays(value: number | undefined);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _enableKeyRotation?;
    get enableKeyRotation(): boolean | undefined;
    set enableKeyRotation(value: boolean | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _isEnabled?;
    get isEnabled(): boolean | undefined;
    set isEnabled(value: boolean | undefined);
    get keyId(): string;
    private _keyUsage?;
    get keyUsage(): string | undefined;
    set keyUsage(value: string | undefined);
    private _policy?;
    get policy(): string | undefined;
    set policy(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
