import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface LambdaAliasConfig extends TerraformMetaArguments {
    readonly description?: string;
    readonly functionName: string;
    readonly functionVersion: string;
    readonly name: string;
    /** routing_config block */
    readonly routingConfig?: LambdaAliasRoutingConfig[];
}
export interface LambdaAliasRoutingConfig {
    readonly additionalVersionWeights?: {
        [key: string]: number;
    };
}
export declare class LambdaAlias extends TerraformResource {
    constructor(scope: Construct, id: string, config: LambdaAliasConfig);
    get arn(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _functionName;
    get functionName(): string;
    set functionName(value: string);
    private _functionVersion;
    get functionVersion(): string;
    set functionVersion(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get invokeArn(): string;
    private _name;
    get name(): string;
    set name(value: string);
    private _routingConfig?;
    get routingConfig(): LambdaAliasRoutingConfig[] | undefined;
    set routingConfig(value: LambdaAliasRoutingConfig[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
