import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface LambdaEventSourceMappingConfig extends TerraformMetaArguments {
    readonly batchSize?: number;
    readonly bisectBatchOnFunctionError?: boolean;
    readonly enabled?: boolean;
    readonly eventSourceArn: string;
    readonly functionName: string;
    readonly maximumBatchingWindowInSeconds?: number;
    readonly maximumRecordAgeInSeconds?: number;
    readonly maximumRetryAttempts?: number;
    readonly parallelizationFactor?: number;
    readonly startingPosition?: string;
    readonly startingPositionTimestamp?: string;
    /** destination_config block */
    readonly destinationConfig?: LambdaEventSourceMappingDestinationConfig[];
}
export interface LambdaEventSourceMappingDestinationConfigOnFailure {
    readonly destinationArn: string;
}
export interface LambdaEventSourceMappingDestinationConfig {
    /** on_failure block */
    readonly onFailure?: LambdaEventSourceMappingDestinationConfigOnFailure[];
}
export declare class LambdaEventSourceMapping extends TerraformResource {
    constructor(scope: Construct, id: string, config: LambdaEventSourceMappingConfig);
    private _batchSize?;
    get batchSize(): number | undefined;
    set batchSize(value: number | undefined);
    private _bisectBatchOnFunctionError?;
    get bisectBatchOnFunctionError(): boolean | undefined;
    set bisectBatchOnFunctionError(value: boolean | undefined);
    private _enabled?;
    get enabled(): boolean | undefined;
    set enabled(value: boolean | undefined);
    private _eventSourceArn;
    get eventSourceArn(): string;
    set eventSourceArn(value: string);
    get functionArn(): string;
    private _functionName;
    get functionName(): string;
    set functionName(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get lastModified(): string;
    get lastProcessingResult(): string;
    private _maximumBatchingWindowInSeconds?;
    get maximumBatchingWindowInSeconds(): number | undefined;
    set maximumBatchingWindowInSeconds(value: number | undefined);
    private _maximumRecordAgeInSeconds?;
    get maximumRecordAgeInSeconds(): number | undefined;
    set maximumRecordAgeInSeconds(value: number | undefined);
    private _maximumRetryAttempts?;
    get maximumRetryAttempts(): number | undefined;
    set maximumRetryAttempts(value: number | undefined);
    private _parallelizationFactor?;
    get parallelizationFactor(): number | undefined;
    set parallelizationFactor(value: number | undefined);
    private _startingPosition?;
    get startingPosition(): string | undefined;
    set startingPosition(value: string | undefined);
    private _startingPositionTimestamp?;
    get startingPositionTimestamp(): string | undefined;
    set startingPositionTimestamp(value: string | undefined);
    get state(): string;
    get stateTransitionReason(): string;
    get uuid(): string;
    private _destinationConfig?;
    get destinationConfig(): LambdaEventSourceMappingDestinationConfig[] | undefined;
    set destinationConfig(value: LambdaEventSourceMappingDestinationConfig[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
