import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface LambdaFunctionEventInvokeConfigConfig extends TerraformMetaArguments {
    readonly functionName: string;
    readonly maximumEventAgeInSeconds?: number;
    readonly maximumRetryAttempts?: number;
    readonly qualifier?: string;
    /** destination_config block */
    readonly destinationConfig?: LambdaFunctionEventInvokeConfigDestinationConfig[];
}
export interface LambdaFunctionEventInvokeConfigDestinationConfigOnFailure {
    readonly destination: string;
}
export interface LambdaFunctionEventInvokeConfigDestinationConfigOnSuccess {
    readonly destination: string;
}
export interface LambdaFunctionEventInvokeConfigDestinationConfig {
    /** on_failure block */
    readonly onFailure?: LambdaFunctionEventInvokeConfigDestinationConfigOnFailure[];
    /** on_success block */
    readonly onSuccess?: LambdaFunctionEventInvokeConfigDestinationConfigOnSuccess[];
}
export declare class LambdaFunctionEventInvokeConfig extends TerraformResource {
    constructor(scope: Construct, id: string, config: LambdaFunctionEventInvokeConfigConfig);
    private _functionName;
    get functionName(): string;
    set functionName(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _maximumEventAgeInSeconds?;
    get maximumEventAgeInSeconds(): number | undefined;
    set maximumEventAgeInSeconds(value: number | undefined);
    private _maximumRetryAttempts?;
    get maximumRetryAttempts(): number | undefined;
    set maximumRetryAttempts(value: number | undefined);
    private _qualifier?;
    get qualifier(): string | undefined;
    set qualifier(value: string | undefined);
    private _destinationConfig?;
    get destinationConfig(): LambdaFunctionEventInvokeConfigDestinationConfig[] | undefined;
    set destinationConfig(value: LambdaFunctionEventInvokeConfigDestinationConfig[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
