import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface LambdaFunctionConfig extends TerraformMetaArguments {
    readonly description?: string;
    readonly filename?: string;
    readonly functionName: string;
    readonly handler: string;
    readonly kmsKeyArn?: string;
    readonly layers?: string[];
    readonly memorySize?: number;
    readonly publish?: boolean;
    readonly reservedConcurrentExecutions?: number;
    readonly role: string;
    readonly runtime: string;
    readonly s3Bucket?: string;
    readonly s3Key?: string;
    readonly s3ObjectVersion?: string;
    readonly sourceCodeHash?: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly timeout?: number;
    /** dead_letter_config block */
    readonly deadLetterConfig?: LambdaFunctionDeadLetterConfig[];
    /** environment block */
    readonly environment?: LambdaFunctionEnvironment[];
    /** file_system_config block */
    readonly fileSystemConfig?: LambdaFunctionFileSystemConfig[];
    /** timeouts block */
    readonly timeouts?: LambdaFunctionTimeouts;
    /** tracing_config block */
    readonly tracingConfig?: LambdaFunctionTracingConfig[];
    /** vpc_config block */
    readonly vpcConfig?: LambdaFunctionVpcConfig[];
}
export interface LambdaFunctionDeadLetterConfig {
    readonly targetArn: string;
}
export interface LambdaFunctionEnvironment {
    readonly variables?: {
        [key: string]: string;
    };
}
export interface LambdaFunctionFileSystemConfig {
    readonly arn: string;
    readonly localMountPath: string;
}
export interface LambdaFunctionTimeouts {
    readonly create?: string;
}
export interface LambdaFunctionTracingConfig {
    readonly mode: string;
}
export interface LambdaFunctionVpcConfig {
    readonly securityGroupIds: string[];
    readonly subnetIds: string[];
}
export declare class LambdaFunction extends TerraformResource {
    constructor(scope: Construct, id: string, config: LambdaFunctionConfig);
    get arn(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _filename?;
    get filename(): string | undefined;
    set filename(value: string | undefined);
    private _functionName;
    get functionName(): string;
    set functionName(value: string);
    private _handler;
    get handler(): string;
    set handler(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get invokeArn(): string;
    private _kmsKeyArn?;
    get kmsKeyArn(): string | undefined;
    set kmsKeyArn(value: string | undefined);
    get lastModified(): string;
    private _layers?;
    get layers(): string[] | undefined;
    set layers(value: string[] | undefined);
    private _memorySize?;
    get memorySize(): number | undefined;
    set memorySize(value: number | undefined);
    private _publish?;
    get publish(): boolean | undefined;
    set publish(value: boolean | undefined);
    get qualifiedArn(): string;
    private _reservedConcurrentExecutions?;
    get reservedConcurrentExecutions(): number | undefined;
    set reservedConcurrentExecutions(value: number | undefined);
    private _role;
    get role(): string;
    set role(value: string);
    private _runtime;
    get runtime(): string;
    set runtime(value: string);
    private _s3Bucket?;
    get s3Bucket(): string | undefined;
    set s3Bucket(value: string | undefined);
    private _s3Key?;
    get s3Key(): string | undefined;
    set s3Key(value: string | undefined);
    private _s3ObjectVersion?;
    get s3ObjectVersion(): string | undefined;
    set s3ObjectVersion(value: string | undefined);
    private _sourceCodeHash?;
    get sourceCodeHash(): string | undefined;
    set sourceCodeHash(value: string | undefined);
    get sourceCodeSize(): number;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _timeout?;
    get timeout(): number | undefined;
    set timeout(value: number | undefined);
    get version(): string;
    private _deadLetterConfig?;
    get deadLetterConfig(): LambdaFunctionDeadLetterConfig[] | undefined;
    set deadLetterConfig(value: LambdaFunctionDeadLetterConfig[] | undefined);
    private _environment?;
    get environment(): LambdaFunctionEnvironment[] | undefined;
    set environment(value: LambdaFunctionEnvironment[] | undefined);
    private _fileSystemConfig?;
    get fileSystemConfig(): LambdaFunctionFileSystemConfig[] | undefined;
    set fileSystemConfig(value: LambdaFunctionFileSystemConfig[] | undefined);
    private _timeouts?;
    get timeouts(): LambdaFunctionTimeouts | undefined;
    set timeouts(value: LambdaFunctionTimeouts | undefined);
    private _tracingConfig?;
    get tracingConfig(): LambdaFunctionTracingConfig[] | undefined;
    set tracingConfig(value: LambdaFunctionTracingConfig[] | undefined);
    private _vpcConfig?;
    get vpcConfig(): LambdaFunctionVpcConfig[] | undefined;
    set vpcConfig(value: LambdaFunctionVpcConfig[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
